package net.bloom.bloomclient.features.module.modules.player

import net.bloom.bloomclient.event.UpdateEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.player.ItemUtils
import net.bloom.bloomclient.utils.struct.MSTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.inventory.ContainerChest

object ModuleStealer : Module(
    name = "Stealer",
    description = "Steal items from chest.",
    category = ModuleCategory.PLAYER
)  {
    private val startDelayValue by int("Start Delay", 1, 0, 10)
    private val closeDelayValue by int("Close Delay", 1, 0, 10)
    private val intervalValue by intRange("Interval", 1, 3, 1, 10)
    private val startDelayTimer = MSTimer()
    private val closeDelayTimer = MSTimer()
    private val timer = MSTimer()
    private var currentDelay = 0L
    var slot = 0

    @EventHandler
    fun onUpdate(e: UpdateEvent) {
        val container = mc.thePlayer.openContainer
        if (container is ContainerChest) {
            if (startDelayTimer.hasTimePassed(startDelayValue * 50L)) {
                for (i in 0 until container.lowerChestInventory.sizeInventory) {
                    val stack = container.lowerChestInventory.getStackInSlot(i)
                    if (stack != null && (timer.hasTimePassed(currentDelay * 50L) || currentDelay == 0L)) {
                        slot = i
                        mc.playerController.windowClick(container.windowId, i, 0, 1, mc.thePlayer)
                        currentDelay = RandomUtils.nextInt(intervalValue.minimum, intervalValue.maximum).toLong()
                        timer.reset()
                    }
                }
            }

            if (ItemUtils.isInventoryFull() || ItemUtils.isInventoryEmpty(container.lowerChestInventory)) {
                if (closeDelayTimer.hasTimePassed(closeDelayValue * 50L)) {
                    mc.thePlayer.closeScreen()
                }
            } else {
                closeDelayTimer.reset()
            }
        } else {
            currentDelay = RandomUtils.nextInt(intervalValue.minimum, intervalValue.maximum).toLong()
            startDelayTimer.reset()
        }
    }
}