package net.bloom.bloomclient.features.module.modules.player

import net.bloom.bloomclient.event.UpdateEvent
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.Module
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.network.play.client.C03PacketPlayer
import net.minecraft.network.play.client.C03PacketPlayer.C06PacketPlayerPosLook
import net.minecraft.potion.Potion

object ModuleRegen : Module(name = "Regen", description = "", category = ModuleCategory.PLAYER) {

    private val health by int("HealthMaximum", 19, 1, 20)
    private val hungerAmount by int("HungerMinimum", 1, 0, 20)
    private val speed by int("Speed", 1, 1, 100)
    private val useC06 by bool("UseC06", true)
    private val onlyPotionEffect by bool("OnlyRegenOnPotionEffect", true)
    private val onlyOnGround by bool("OnlyRegenOnGround", true)

    @EventHandler
    fun onUpdate(event: UpdateEvent) {
        if (mc.thePlayer.isEntityAlive && !mc.thePlayer.capabilities.isCreativeMode && mc.thePlayer.health <= health &&
            mc.thePlayer.foodStats.foodLevel >= hungerAmount && (!onlyPotionEffect || mc.thePlayer.isPotionActive(Potion.regeneration)) &&
            (!onlyOnGround || mc.thePlayer.onGround)) {

            repeat(speed) {
                if (useC06) mc.netHandler.addToSendQueue(C06PacketPlayerPosLook(mc.thePlayer))
                else mc.netHandler.addToSendQueue(C03PacketPlayer(mc.thePlayer.onGround))
            }
        }
    }

}