package net.bloom.bloomclient.features.module.modules.player

import net.bloom.bloomclient.event.ReceivedPacketEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.network.play.server.S32PacketConfirmTransaction


object ModuleInventorySync : Module(name = "InventorySync", description = "", category = ModuleCategory.PLAYER) {

    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        val packet = event.packet

        if (packet is S32PacketConfirmTransaction) {
            val inventory = mc.thePlayer.inventoryContainer

            if (packet.windowId == inventory.windowId) {
                val action = packet.actionNumber

                if (action > 0 && action < inventory.transactionID)
                    inventory.transactionID = (action + 1).toShort()
            }
        }
    }

}