package net.bloom.bloomclient.features.module.modules.player

import net.bloom.bloomclient.event.UpdateEvent
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.Module
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.item.ItemBucketMilk
import net.minecraft.item.ItemFood
import net.minecraft.item.ItemPotion
import net.minecraft.network.play.client.C03PacketPlayer
import net.minecraft.network.play.client.C03PacketPlayer.*

object ModuleFastUse : Module(name = "FastUse", description = "", category = ModuleCategory.PLAYER) {

    private val mode by list("Mode", "Instant", arrayOf("Instant"))
    private val packetType by list("Packet", "C03", arrayOf("C03", "C04", "C05", "C06"))
    private val packetAmount by int("PacketAmount", 1, 1, 100)

    @EventHandler
    fun onUpdate(event: UpdateEvent) {
        if (!mc.thePlayer.isUsingItem)
            return

        val usingItem = mc.thePlayer.itemInUse.item

        if (usingItem is ItemFood || usingItem is ItemBucketMilk || usingItem is ItemPotion)
            when (mode.lowercase()) {
                "instant" -> repeat(packetAmount) {
                    when (packetType.lowercase()) {
                        "c03" -> mc.netHandler.addToSendQueue(C03PacketPlayer(mc.thePlayer.onGround))
                        "c04" -> mc.netHandler.addToSendQueue(C04PacketPlayerPosition(mc.thePlayer))
                        "c05" -> mc.netHandler.addToSendQueue(C05PacketPlayerLook(mc.thePlayer))
                        "c06" -> mc.netHandler.addToSendQueue(C06PacketPlayerPosLook(mc.thePlayer))
                    }
                }
            }
    }

}