package net.bloom.bloomclient.features.module.modules.player

import net.bloom.bloomclient.event.PreUpdateEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.player.InventoryUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.item.ItemStack
import net.minecraft.util.MovingObjectPosition
import org.lwjgl.input.Mouse
import net.minecraft.client.option.options.devices.KeyBinding

object ModuleAutoTool: Module(
    name = "AutoTool",
    category = ModuleCategory.PLAYER
) {
    private var oldSlot = -1
    private var wasDigging = false
    private val spoof = bool("ItemSpoof", false)

    @EventHandler
    fun onUpdate(event: PreUpdateEvent) {
        val obj = mc.objectMouseOver ?: return

        if ((Mouse.isButtonDown(0) || KeyBinding.keyBindAttack.isKeyDown) &&
            obj.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK
        ) {
            val block = mc.theWorld.getBlockState(obj.blockPos).block
            var bestSlot = -1
            var bestStrength = 0f

            if (!wasDigging) {
                oldSlot = mc.thePlayer.inventory.currentItem
            }

            for (i in 0..8) {
                val stack: ItemStack? = mc.thePlayer.inventory.getStackInSlot(i)
                if (stack != null) {
                    val strength = stack.getStrVsBlock(block)
                    if (strength > bestStrength) {
                        bestStrength = strength
                        bestSlot = i
                    }
                }
            }

            if (bestSlot != -1) {
                if (spoof.value) {
                    InventoryUtils.startSpoofing(bestSlot)
                } else {
                    mc.thePlayer.inventory.currentItem = bestSlot
                }
            }

            wasDigging = true
        } else {
            if (wasDigging) {
                mc.thePlayer.inventory.currentItem = oldSlot
                InventoryUtils.stopSpoofing()
                wasDigging = false
            } else {
                oldSlot = mc.thePlayer.inventory.currentItem
            }
        }
    }

    override fun onDisable() {
        if (wasDigging) {
            mc.thePlayer.inventory.currentItem = oldSlot
            wasDigging = false
        }
        InventoryUtils.stopSpoofing()
    }
}

