package net.bloom.bloomclient.features.module.modules.player

import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.player.autofood.LegitAutoFoodMode
import net.bloom.bloomclient.features.module.modules.player.autofood.PacketAutoFoodMode
import net.bloom.bloomclient.utils.player.InventoryUtils
import net.bloom.bloomclient.utils.struct.MSTimer
import net.minecraft.init.Items
import net.minecraft.item.ItemFood
import net.minecraft.potion.Potion

object ModuleAutoFood : Module(name = "AutoFood", description = "", category = ModuleCategory.PLAYER) {
    private val mode by mode("Mode", arrayOf(PacketAutoFoodMode, LegitAutoFoodMode))

    private val gapple by bool("Gapple", true)
    private val health by int("Health", 12, 0, 20)
    private val noAbsorption by bool("NoAbsorption", true)
    private val waitRegen by bool("WaitRegen", true)
    private val delay by int("Delay", 50, 50, 2000)

    val msTimer = MSTimer()

    override fun onEnable() {
        mode.onEnable()
        msTimer.reset()
    }

    override fun onDisable() {
        mode.onDisable()
    }

    fun canFood(): Boolean {
        mc.thePlayer ?: return false

        if (noAbsorption && mc.thePlayer.absorptionAmount > 0)
            return false

        if (waitRegen && mc.thePlayer.isPotionActive(Potion.regeneration))
            return false

        if (mc.thePlayer.health > health)
            return false

        if (!msTimer.hasTimePassed(delay))
            return false

        return true
    }

    fun findFood() = if (gapple) {
        InventoryUtils.findItem(36, 44, Items.golden_apple)
    } else {
        InventoryUtils.findItem(36, 44) { _, item -> item is ItemFood && item != Items.golden_apple }
    }
}