package net.bloom.bloomclient.features.module.modules.world

import net.bloom.bloomclient.event.MoveInputEvent
import net.bloom.bloomclient.event.PreUpdateEvent
import net.bloom.bloomclient.features.component.components.player.PacketComponent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.Constants
import net.bloom.bloomclient.utils.player.InventoryUtils.isBadStack
import net.bloom.bloomclient.utils.struct.MSTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.gui.inventory.GuiInventory
import net.minecraft.enchantment.EnchantmentHelper
import net.minecraft.enchantment.Enchantments
import net.minecraft.item.ItemArmor
import net.minecraft.item.ItemStack
import net.minecraft.network.play.client.C0DPacketCloseWindow
import net.minecraft.network.play.client.C16PacketClientStatus
import org.lwjgl.input.Keyboard

object ModuleAutoArmor: Module(name = "AutoArmor", category = ModuleCategory.WORLD) {

    private val startTimer = MSTimer()
    private val timer = MSTimer()
    private val mode = list("Mode", "Spoof", arrayOf("OpenInv", "Spoof"))
    private val startDelay = float("StartDelay", 150.0f, 0.0f, 1000.0f)
    private val speed = float("Speed", 150f, 0f, 1000f)

    private var isInventoryOpen = false

    @EventHandler
    fun onMoveButton(event: MoveInputEvent) {
        if (isInventoryOpen) {
            event.forward = 0.0f
            event.strafe = 0.0f
            event.jump = false
            event.sneak = false
        }
    }

    @EventHandler
    fun onUpdate(e: PreUpdateEvent) {
        if (mode.get() == "Spoof" && mc.currentScreen != null) {
            return
        }

        if (mode.get() == "OpenInv") {
            if (mc.currentScreen == null) {
                startTimer.reset()
            }
            if (!startTimer.hasTimeElapsed(startDelay.get().toDouble(), false)) {
                return
            }
        }

        if (timer.hasTimeElapsed(speed.value.toDouble(), false)) {
            if (mode.get() == "OpenInv"
                && mc.currentScreen !is GuiInventory
            ) return

            for (type in 1..4) {
                if (mc.thePlayer.inventoryContainer.getSlot(4 + type).hasStack) {
                    val `is` = mc.thePlayer.inventoryContainer.getSlot(4 + type).stack

                    if (isBestArmor(`is`, type)) continue

                    openInv(mode.get())
                    drop(4 + type)

                    timer.reset()
                    if (speed.get() != 0f) break
                }
            }
            for (type in 1..4) {
                if (timer.time > speed.get()) {
                    for (i in 9..44) {
                        if (mc.thePlayer.inventoryContainer.getSlot(i).hasStack) {
                            val `is` = mc.thePlayer.inventoryContainer.getSlot(i).stack
                            if (getProtection(`is`) > 0.0f) {
                                if (isBestArmor(`is`, type)
                                    && !isBadStack(`is`, preferSword = true, keepTools = true)
                                ) {
                                    openInv(mode.get())
                                    shiftClick(i)

                                    timer.reset()
                                    if (speed.get() != 0f) break
                                }
                            }
                        }
                    }
                }
            }
        }
        if (timer.time > 75) {
            closeInv(mode.get())
        }
    }

    fun openInv(mode: String) {
        if (mode.equals("Spoof", ignoreCase = true)) {
            if (!isInventoryOpen && mc.currentScreen !is GuiInventory) {
                PacketComponent.sendPacket(C16PacketClientStatus(C16PacketClientStatus.EnumState.OPEN_INVENTORY_ACHIEVEMENT))
                isInventoryOpen = true
            }
        }
    }

    fun closeInv(mode: String) {
        if (mode.equals("Spoof", ignoreCase = true)) {
            if (isInventoryOpen && mc.currentScreen !is GuiInventory) {
                PacketComponent.sendPacket(C0DPacketCloseWindow(mc.thePlayer.inventoryContainer.windowId))
                for (bind in Constants.MOVING_KEYS)
                    bind.isKeyDown = Keyboard.isKeyDown(bind.keyCode)

                isInventoryOpen = false
            }
        }
    }


    fun getProtection(stack: ItemStack): Float {
        var prot = 0.0f

        if (stack.item is ItemArmor) {
            val armor = stack.item as ItemArmor
            prot =
                (prot + armor.damageReduceAmount + ((100 - armor.damageReduceAmount) * EnchantmentHelper.getEnchantmentLevel(
                    Enchantments.protection.effectId,
                    stack
                )) * 0.0075).toFloat()
            prot = (prot + EnchantmentHelper.getEnchantmentLevel(
                Enchantments.blastProtection.effectId,
                stack
            ) / 100.0).toFloat()
            prot = (prot + EnchantmentHelper.getEnchantmentLevel(
                Enchantments.fireProtection.effectId,
                stack
            ) / 100.0).toFloat()
            prot = (prot + EnchantmentHelper.getEnchantmentLevel(Enchantments.thorns.effectId, stack) / 100.0).toFloat()
            prot =
                (prot + EnchantmentHelper.getEnchantmentLevel(Enchantments.unbreaking.effectId, stack) / 50.0).toFloat()
            prot =
                (prot + EnchantmentHelper.getEnchantmentLevel(Enchantments.protection.effectId, stack) / 100.0).toFloat()
        }

        return prot
    }

    fun isBestArmor(stack: ItemStack, type: Int): Boolean {
        val prot = getProtection(stack)
        var strType = ""

        when (type) {
            1 -> {
                strType = "helmet"
            }
            2 -> {
                strType = "chestplate"
            }
            3 -> {
                strType = "leggings"
            }
            4 -> {
                strType = "boots"
            }
        }

        if (!stack.unlocalizedName.contains(strType)) {
            return false
        }

        for (i in 5..44) {
            if (mc.thePlayer.inventoryContainer.getSlot(i).hasStack) {
                val `is` = mc.thePlayer.inventoryContainer.getSlot(i).stack

                if (getProtection(`is`) > prot && `is`.unlocalizedName.contains(strType)) {
                    return false
                }
            }
        }
        return true
    }

    fun drop(slot: Int) {
        mc.playerController.windowClick(
            mc.thePlayer.inventoryContainer.windowId, slot, 1, 4,
            mc.thePlayer
        )
    }

    fun shiftClick(slot: Int) {
        mc.playerController.windowClick(
            mc.thePlayer.inventoryContainer.windowId, slot, 0, 1,
            mc.thePlayer
        )
    }
}