package net.bloom.bloomclient.features.module.modules.other;

import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.minecraft.entity.player.EntityPlayer
import net.minecraft.item.ItemArmor

object ModuleTeams : Module(name = "Teams", description = "Prevents killaura from attacking team mates.", category = ModuleCategory.OTHER) {

    private val scoreboardValue = bool("ScoreboardTeam", true)
    private val colorValue = bool("Color", false)
    private val armorValue = bool("ArmorColor", true)

    /**
     * Check if [entity] is in your own team using scoreboard, name color or team prefix
     */
    fun isInYourTeam(entity: EntityPlayer): Boolean {
        mc.thePlayer ?: return false

        if (scoreboardValue.get() && mc.thePlayer.team != null && entity.team != null &&
            mc.thePlayer.team.isSameTeam(entity.team)) {
            return true
        }

        if (armorValue.get()) {
            val myHead = mc.thePlayer.inventory.armorInventory[3]
            val entityHead = entity.inventory.armorInventory[3]

            if (myHead != null && entityHead != null) {

                val myItemArmor = myHead.item as ItemArmor
                val entityItemArmor = myHead.item as ItemArmor

                if (myItemArmor.getColor(myHead) == entityItemArmor.getColor(entityHead))
                    return true
            }
        }

        if (colorValue.get() && mc.thePlayer.displayName != null && entity.displayName != null) {
            val targetName = entity.displayName.formattedText.replace("§r", "")
            val clientName = mc.thePlayer.displayName.formattedText.replace("§r", "")
            return targetName.startsWith("§${clientName[1]}")
        }

        // TODO: Mineblaze Simple teams by color (Red for enemies, Green for teammates)

        return false
    }

}