package net.bloom.bloomclient.features.module.modules.other

import net.bloom.bloomclient.event.ReceivedPacketEvent
import net.bloom.bloomclient.features.component.components.player.PacketComponent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.ClientUtils.LOGGER
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.network.play.client.C19PacketResourcePackStatus
import net.minecraft.network.play.server.S48PacketResourcePackSend
import java.net.URI
import java.net.URISyntaxException

object ModulePackSpoofer : Module(name = "PackSpoofer", description = "", category = ModuleCategory.OTHER) {
    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        val packet = event.packet

        if (packet is S48PacketResourcePackSend) {
            val url = packet.url
            val hash = packet.hash

            try {
                val scheme = URI(url).scheme
                val isLevelProtocol = "level" == scheme

                if ("http" != scheme && "https" != scheme && !isLevelProtocol)
                    throw URISyntaxException(url, "Wrong protocol")

                if (isLevelProtocol && (".." in url || !url.endsWith("/resources.zip")))
                    throw URISyntaxException(url, "Invalid levelstorage resourcepack path")

                PacketComponent.sendPackets(
                    C19PacketResourcePackStatus(packet.hash, C19PacketResourcePackStatus.Action.ACCEPTED),
                    C19PacketResourcePackStatus(packet.hash, C19PacketResourcePackStatus.Action.SUCCESSFULLY_LOADED)
                )
            } catch (e: URISyntaxException) {
                LOGGER.error("Failed to handle resource pack", e)
                PacketComponent.sendPacket(C19PacketResourcePackStatus(hash, C19PacketResourcePackStatus.Action.FAILED_DOWNLOAD))
            }

            event.isCancelled = true
        }
    }
}