package net.bloom.bloomclient.features.module.modules.other

import net.bloom.bloomclient.event.ReceivedPacketEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.file.FileManager
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.block.material.MapColor
import net.minecraft.network.play.server.S34PacketMaps
import java.awt.image.BufferedImage
import java.io.File
import java.util.*
import javax.imageio.ImageIO

object ModuleCaptureCaptchaImage : Module(name = "CaptureCaptchaImage", description = "", category = ModuleCategory.OTHER) {

    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        val packet = event.packet

        if (packet is S34PacketMaps) {
            val mapDataBytes = packet.mapDataBytes
            val mapColors = MapColor.mapColorArray

            val image = BufferedImage(128, 128, BufferedImage.TYPE_INT_RGB)

            for (y in 0 until 128) {
                for (x in 0 until 128) {
                    val colorIndex = mapDataBytes[y * 128 + x].toInt() and 0xFF
                    val mapColor = if (colorIndex / 4 < mapColors.size) mapColors[colorIndex / 4] else MapColor.airColor
                    val shade = colorIndex and 3
                    val rgb = mapColor.getMapColor(shade)
                    image.setRGB(x, y, rgb)
                }
            }

            val file = File(FileManager.imagesFolder, "${UUID.randomUUID()}.png")
            ImageIO.write(image, "png", file)
        }
    }

}