package net.bloom.bloomclient.features.module.modules.movement.speed

import net.bloom.bloomclient.event.PostStrafeEvent
import net.bloom.bloomclient.event.PostVelocityEvent
import net.bloom.bloomclient.event.UpdateEvent
import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.utils.player.MovementUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.entity.Entity
import net.minecraft.entity.EntityLivingBase
import net.minecraft.util.MathHelper
import kotlin.math.cos
import kotlin.math.sin

object GrimCollideSpeedMode: Mode("GrimCollide") {

    private val jump by bool("Jump", false)
    private val boostSpeed by int("BoostSpeed", 4, 0, 10)

    @EventHandler
    fun onStrafe(event: PostStrafeEvent) {
        if (!mc.thePlayer.isMoving)
            return

        if (jump && mc.thePlayer.onGround && !KeyBinding.keyBindJump.isKeyDown)
            mc.thePlayer.jump()

        val grimPlayerBox = mc.thePlayer.entityBoundingBox.expand(1.0, 1.0, 1.0)
        val collisions = mc.theWorld.loadedEntityList.count { canCauseSpeed(it) && grimPlayerBox.intersectsWith(it.entityBoundingBox) }
        val yaw = MovementUtils.getDirectionToRadians(mc.thePlayer.rotationYaw)

        val boost = boostSpeed / 100f * collisions
        mc.thePlayer.addVelocity(-sin(yaw) * boost, 0.0, cos(yaw) * boost)
    }

    private fun canCauseSpeed(entity: Entity): Boolean {
        return entity != mc.thePlayer && entity is EntityLivingBase
    }
}

object IntaveSpeedMode: Mode("Intave") {
    private val timer by bool("Timer", true)

    @EventHandler
    fun onUpdate(event: UpdateEvent) {
        mc.thePlayer ?: return

        if (mc.thePlayer.onGround && mc.thePlayer.isSprinting && mc.thePlayer.isMoving)
            mc.thePlayer.jump()

        when (mc.thePlayer.offGroundTicks) {
            1 -> {
                mc.thePlayer.motionX *= 1.04
                mc.thePlayer.motionZ *= 1.04
            }

            2, 3, 4 -> {
                mc.thePlayer.motionX *= 1.02
                mc.thePlayer.motionZ *= 1.02
            }
        }

        if (timer) {
            mc.timer.timerSpeed = 1.002f
        }
    }
}

object LegitSpeedMode: Mode("Legit") {
    @EventHandler
    fun onUpdate(event: UpdateEvent) {
        if (MovementUtils.isMoving && mc.thePlayer.onGround && !KeyBinding.keyBindJump.isKeyDown)
            mc.thePlayer.jump()
    }
}