package net.bloom.bloomclient.features.module.modules.movement.noslow.shared

import net.bloom.bloomclient.event.*
import net.bloom.bloomclient.features.component.components.player.MovementCorrection
import net.bloom.bloomclient.features.component.components.player.RotationComponent
import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.movement.ModuleNoSlow
import net.bloom.bloomclient.features.module.modules.movement.ModuleSpeed
import net.bloom.bloomclient.utils.player.MovementUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.util.Rotation


class VanillaNoSlow: Mode("Vanilla")

class CustomNoSlow: Mode("Custom") {
    private val bowSwitchPre by bool("SwitchItemPre", false)
    private val bowSwitchPost by bool("SwitchItemPost", false)
    private val bowC08Pre by bool("C08Pre", false)
    private val bowC08Post by bool("C08Post", true)
    private val bowC08Update by bool("C08Update", false)
    private val bowC0CPre by bool("C0CPre", false)
    private val bowC0CPost by bool("C0CPost", false)
    private val bowC07NRPre by bool("C07NReleasePre", false)
    private val bowC07NRPost by bool("C07NReleasePost", false)
    private val bowC07NRUpdate by bool("C07NReleaseUp", false)
    private val bowC07BRPre by bool("C07BReleasePre", false)
    private val bowC07BRPost by bool("C07BReleasePost", false)
    private val bowC07BRUpdate by bool("C07BReleaseUp", false)
    private val bowC07NDPre by bool("C07NDropPre", false)
    private val bowC07NDPost by bool("C07NDropPost", false)
    private val bowC07NDUpdate by bool("C07NDropUp", false)
    private val bowC07BDPre by bool("C07BDropPre", false)
    private val bowC07BDPost by bool("C07BDropPost", false)
    private val bowC07BDUpdate by bool("C07BDropUp", false)

    @EventHandler
    fun onPreMotion(event: PreMotionEvent) {
        if (bowC08Pre) ModuleNoSlow.sendC08()
        if (bowC0CPre) ModuleNoSlow.sendC0C()
        if (bowC07NRPre) ModuleNoSlow.sendC07NR()
        if (bowC07BRPre) ModuleNoSlow.sendC07BR()
        if (bowC07NDPre) ModuleNoSlow.sendC07ND()
        if (bowC07BDPre) ModuleNoSlow.sendC07BD()

        if (bowSwitchPre)
            ModuleNoSlow.sendSwitchPackets()
    }

    @EventHandler
    fun onPostMotion(event: PostMotionEvent) {
        if (bowC08Post) ModuleNoSlow.sendC08()
        if (bowC0CPost) ModuleNoSlow.sendC0C()
        if (bowC07NRPost) ModuleNoSlow.sendC07NR()
        if (bowC07BRPost) ModuleNoSlow.sendC07BR()
        if (bowC07NDPost) ModuleNoSlow.sendC07ND()
        if (bowC07BDPost) ModuleNoSlow.sendC07BD()

        if (bowSwitchPost)
            ModuleNoSlow.sendSwitchPackets()
    }

    @EventHandler
    fun onUpdate(event: UpdateEvent) {
        if (bowC08Update) ModuleNoSlow.sendC08()
        if (bowC07NRUpdate) ModuleNoSlow.sendC07NR()
        if (bowC07BRUpdate) ModuleNoSlow.sendC07BR()
        if (bowC07NDUpdate) ModuleNoSlow.sendC07ND()
        if (bowC07BDUpdate) ModuleNoSlow.sendC07BD()
    }
}

class Grim3NoSlow: Mode("Grim3") {
    @EventHandler
    fun onUpdate(event: UpdateEvent) {
        if (mc.thePlayer.isUsingItem && !mc.thePlayer.onGround && !KeyBinding.keyBindRight.isKeyDown && !KeyBinding.keyBindLeft.isKeyDown)
            RotationComponent.setRotation(
                rotation = Rotation(mc.thePlayer.playerYaw + 45.0F, mc.thePlayer.playerPitch),
                yawSpeed = 10f,
                pitchSpeed = 10f,
                fixType = MovementCorrection.Type.SILENT
            )

        if (mc.thePlayer.isInWeb)
            MovementUtils.strafe(0.64)

        if (mc.thePlayer.isUsingItem && mc.thePlayer.onGroundTicks > 1 && !KeyBinding.keyBindJump.isKeyDown) {
            if (!ModuleSpeed.state) {
                MovementUtils.boost(2.0E-4)
            } else {
                MovementUtils.boost(1.0E-4)
            }

            RotationComponent.setRotation(
                rotation = Rotation(mc.thePlayer.playerYaw + 45.0F, mc.thePlayer.playerPitch),
                yawSpeed = 10f,
                pitchSpeed = 10f,
                fixType = MovementCorrection.Type.SILENT
            )
        }
    }

    @EventHandler
    fun onPostUpdate(event: PostUpdateEvent) {
        if (mc.thePlayer.isUsingItem)
            mc.thePlayer.setSprinting(true)
    }

    @EventHandler
    fun onRightClick(event: RightClickEvent) {
        if (mc.thePlayer.offGroundTicks % 2 == 1 && !mc.thePlayer.onGround)
            event.isCancelled = true
    }

    @EventHandler
    fun onSlowDown(event: SlowDownEvent) {
        if (mc.thePlayer.isUsingItem)
            if (ModuleSpeed.state)
                MovementUtils.boost(1e-4)
    }
}

class OldGrimSwitchItem: Mode("OldGrimSwitchItem") {
    @EventHandler
    fun onPreMotion(event: PreMotionEvent) {
        if (mc.thePlayer.isUsingItem) {
            ModuleNoSlow.sendSwitchPackets()
        }
    }
}