package net.bloom.bloomclient.features.module.modules.movement.fly

import net.bloom.bloomclient.event.*
import net.bloom.bloomclient.features.component.components.player.PacketComponent
import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.movement.ModuleFly.getDirection
import net.bloom.bloomclient.features.module.modules.movement.ModuleFly.isMoving
import net.bloom.bloomclient.utils.player.MovementUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.network.play.client.C03PacketPlayer
import net.minecraft.network.play.client.C03PacketPlayer.C04PacketPlayerPosition
import net.minecraft.network.play.client.C03PacketPlayer.C06PacketPlayerPosLook
import net.minecraft.network.play.server.S12PacketEntityVelocity
import kotlin.math.cos
import kotlin.math.sin


object VanillaFly: Mode("Vanilla") {
    private val horizontalSpeed by float("HorizontalSpeed", 0.1f, 0.1f, 5f)
    private val verticalSpeed by float("VerticalSpeed", 0f, 1f, 2f)

    @EventHandler
    fun onUpdate(event: UpdateEvent) {
        mc.thePlayer.capabilities.isFlying = false

        mc.thePlayer.motionX = 0.0
        mc.thePlayer.motionY = 0.0
        mc.thePlayer.motionZ = 0.0
        if (KeyBinding.keyBindJump.isKeyDown)
            mc.thePlayer.motionY += verticalSpeed * 0.5

        if (KeyBinding.keyBindSneak.isKeyDown)
            mc.thePlayer.motionY -= verticalSpeed * 0.5

        MovementUtils.strafe(horizontalSpeed.toDouble())
    }
}

object GrimPacket: Mode("GrimPacket"){
    private val speed by float("Speed", 1.0f, 0.1f, 5.0f)
    private val vertical by bool("VerticalSpeedMatch", true)

    @EventHandler
    fun onMove(event: MoveEvent) {
        if (isMoving()) {
            val dir = getDirection()

            val xDir = cos(Math.toRadians(dir + 90))
            val zDir = sin(Math.toRadians(dir + 90))

            event.x = xDir * speed
            event.z = zDir * speed
        } else {
            event.x = 0.0
            event.z = 0.0
        }

        var ySpeed = 0.0

        if (KeyBinding.keyBindJump.isKeyDown) ySpeed += speed
        if (KeyBinding.keyBindSneak.isKeyDown) ySpeed -= speed

        event.y = if (vertical) ySpeed else ySpeed / 2

        PacketComponent.sendPacketNoEvent(C06PacketPlayerPosLook(mc.thePlayer))
    }

    @EventHandler
    fun onPacket(event: PacketEvent) {
        val packet = event.packet

        if (packet is C03PacketPlayer) {
            PacketComponent.sendPacketNoEvent(
                C06PacketPlayerPosLook(
                    packet.x,
                    packet.y,
                    packet.z,
                    packet.yaw,
                    packet.pitch,
                    packet.isOnGround
                )
            )
        }
    }
}

object GrimFly: Mode("Grim") {
    private val glide by bool("Glide", true)
    private val speed by float("Speed", 0.275f, 0f, 0.32f)
    private val timer by float("Timer", 1f, 0.1f, 10f)

    private var shouldResetMotion = false
    private var shouldGlide = false

    override fun onEnable() {
        shouldResetMotion = false
        shouldGlide = false
    }

    override fun onDisable() {
        mc.timer.timerSpeed = 1f
    }

    @EventHandler
    fun onPostStrafe(event: PostStrafeEvent) {
        mc.timer.timerSpeed = timer

        if (!shouldResetMotion && mc.thePlayer.fallDistance > 0.0f) {
            PacketComponent.sendPacket(C03PacketPlayer(true))
            mc.thePlayer.fallDistance = 0.0f
            shouldResetMotion = true
        }

        if (shouldResetMotion) {
            mc.thePlayer.motionX = 0.0
            mc.thePlayer.motionZ = 0.0
            mc.thePlayer.motionY = 0.0
        }

        if (shouldGlide) {
            MovementUtils.preventDiagonalSpeed()
            MovementUtils.boost(speed.toDouble())
            mc.thePlayer.motionY = if (!glide) -2.0E-4 else -1.1E-4
            MovementUtils.preventDiagonalSpeed()
            shouldGlide = false
        }

        MovementUtils.preventDiagonalSpeed()
    }

    @EventHandler
    fun onPreMotion(event: PreMotionEvent) {
        if (shouldResetMotion)
            event.isCancelled = true
    }

    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        val packet = event.packet

        if (packet is S12PacketEntityVelocity && packet.entityID == mc.thePlayer.entityId) {
            shouldResetMotion = false
            event.isCancelled = true
            shouldGlide = true
        }
    }
}