package net.bloom.bloomclient.features.module.modules.movement

import net.bloom.bloomclient.event.MoveEvent
import net.bloom.bloomclient.event.PreMotionEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.combat.ModuleKillAura
import net.bloom.bloomclient.utils.player.RotationUtils.getRotationsEntity
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.entity.EntityLivingBase
import kotlin.math.cos
import kotlin.math.sign
import kotlin.math.sin
import kotlin.math.sqrt


object ModuleTargetStrafe : Module(
    name = "TargetStrafe",
    description = "Strafes around a target in a circle",
    category = ModuleCategory.MOVEMENT,
) {
    private var direction = 1.0
    override val tag: String
        get() = "Adaptive"

    @EventHandler
    fun onMotion(event: PreMotionEvent) {
        if (mc.thePlayer.isCollidedHorizontally){
            this.direction = -this.direction
        }
    }

    @EventHandler
    fun onMove(event: MoveEvent) {
        val target = ModuleKillAura.currentTarget ?: return

        if(canStrafe){
            val motionX = event.x
            val motionZ = event.z
            val rotYaw = getRotationsEntity(target).yaw
            val moveSpeed = sqrt(motionX * motionX + motionZ * motionZ)

            if (mc.thePlayer.getDistanceToEntity(target) <= 2.5f)
                setSpeed(event, moveSpeed, rotYaw, direction, 0.0)
            else
                setSpeed(event, moveSpeed, rotYaw, direction, 1.0)
        }
    }

    private fun setSpeed(
        event: MoveEvent,
        speed: Double,
        yawIn: Float,
        strafeIn: Double,
        forwardIn: Double
    ) {
        var forward = forwardIn
        var strafe = strafeIn
        var yaw = yawIn

        if (forward == 0.0 && strafe == 0.0) {
            event.x = 0.0
            event.z = 0.0
            return
        }

        if (forward != 0.0) {
            yaw += when {
                strafe > 0.0 -> if (forward > 0.0) -45f else 45f
                strafe < 0.0 -> if (forward > 0.0) 45f else -45f
                else -> 0f
            }
            strafe = 0.0
            forward = forward.sign
        }

        if (strafe != 0.0) {
            strafe = strafe.sign
        }

        val rad = Math.toRadians(yaw + 90.0)
        val cos = cos(rad)
        val sin = sin(rad)

        event.x = forward * speed * cos + strafe * speed * sin
        event.z = forward * speed * sin - strafe * speed * cos
    }

    private val canStrafe: Boolean
        get() = (
            ModuleKillAura.state &&
            mc.thePlayer.isMoving &&
            !mc.thePlayer.isSneaking &&
            KeyBinding.keyBindForward.isKeyDown &&
            !KeyBinding.keyBindRight.isKeyDown &&
            !KeyBinding.keyBindLeft.isKeyDown &&
            !KeyBinding.keyBindBack.isKeyDown
        )
}