package net.bloom.bloomclient.features.module.modules.movement

import net.bloom.bloomclient.event.SlowDownEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.combat.ModuleKillAura
import net.bloom.bloomclient.features.module.modules.movement.noslow.*
import net.bloom.bloomclient.features.module.modules.movement.noslow.shared.*
import net.bloom.bloomclient.utils.struct.MSTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.item.*
import net.minecraft.network.play.client.C07PacketPlayerDigging
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement
import net.minecraft.network.play.client.C09PacketHeldItemChange
import net.minecraft.network.play.client.C0CPacketInput
import net.minecraft.util.BlockPos
import net.minecraft.util.EnumFacing

object ModuleNoSlow: Module(name = "NoSlow", description = "Remove Slow", category = ModuleCategory.MOVEMENT) {

    private val swordModes by mode("SwordMode", arrayOf(
        VanillaNoSlow(),
        IntaveSwordNoSlow,
        Grim3NoSlow(),
        OldGrimSwitchItem(),
        CustomNoSlow()
    ))

    private val swordForwardMultiplier by float("SwordForwardMultiplier", 1f, 0.2f, 1f)
    private val swordStrafeMultiplier by float("SwordStrafeMultiplier", 1f, 0.2f, 1f)
    private val swordStartSlowTimer by int("SwordTimer", 0, 0, 200)
    private val sprintSword by bool("SprintSword", true)
    private val swordTimer = MSTimer()

    private val consumeModes by mode("ConsumeMode", arrayOf(
        VanillaNoSlow(),
        IntaveConsumeNoSlow,
        Grim3NoSlow(),
        OldGrimSwitchItem(),
        CustomNoSlow()
    ))

    private val consumeForwardMultiplier by float("ConsumeForwardMultiplier", 1f, 0.2f, 1f)
    private val consumeStrafeMultiplier by float("ConsumeStrafeMultiplier", 1f, 0.2f, 1f)
    private val consumeStartSlowTimer by int("ConsumeSwordTimer", 0, 0, 300)
    private val sprintConsume by bool("SprintConsume", true)
    private val consumeTimer = MSTimer()

    private val bowModes by mode("BowMode", arrayOf(
        VanillaNoSlow(),
        Grim3NoSlow(),
        OldGrimSwitchItem(),
        CustomNoSlow()
    ))

    private val bowForwardMultiplier by float("BowForwardMultiplier", 1f, 0.2f, 1f)
    private val bowStrafeMultiplier by float("BowStrafeMultiplier", 1f, 0.2f, 1f)
    private val bowStartSlowTimer by int("BowSwordTimer", 0, 0, 300)
    private val sprintBow by bool("SprintBow", true)
    private val bowTimer = MSTimer()

    val isUsingItem: Boolean
        get() = mc.thePlayer?.heldItem != null && (mc.thePlayer.isUsingItem || ModuleKillAura.renderBlocking)

    val isUsingSword: Boolean
        get() {
            val item = mc.thePlayer?.heldItem?.item ?: return false
            return isUsingItem && item is ItemSword
        }

    val isUsingFood: Boolean
        get() {
            val item = mc.thePlayer?.heldItem?.item ?: return false
            return isUsingItem && (item is ItemFood || item is ItemPotion || item is ItemBucketMilk)
        }

    val isUsingBow: Boolean
        get() {
            val item = mc.thePlayer?.heldItem?.item ?: return false
            return isUsingItem && item is ItemBow
        }

    override fun onEnable() {
        swordTimer.reset()

        swordModes.onEnable()
        consumeModes.onEnable()
    }

    override fun onDisable() {
        swordModes.onDisable()
        consumeModes.onDisable()
    }

    @EventHandler
    fun onSlowDown(event: SlowDownEvent) {
        if (isUsingSword && swordTimer.hasTimePassed(swordStartSlowTimer)) {
            event.forward = swordForwardMultiplier
            event.strafe = swordStrafeMultiplier
            event.sprint = sprintSword
        } else {
            swordTimer.reset()
        }

        if (isUsingFood && consumeTimer.hasTimePassed(consumeStartSlowTimer)) {
            event.forward = consumeForwardMultiplier
            event.strafe = consumeStrafeMultiplier
            event.sprint = sprintConsume
        } else {
            consumeTimer.reset()
        }

        if (isUsingBow && bowTimer.hasTimePassed(bowStartSlowTimer)) {
            event.forward = bowForwardMultiplier
            event.strafe = bowStrafeMultiplier
            event.sprint = sprintBow
        } else {
            bowTimer.reset()
        }
    }

    fun sendSwitchPackets() {
        mc.netHandler.addToSendQueue(C09PacketHeldItemChange(mc.thePlayer.inventory.currentItem % 8 + 1))
        mc.netHandler.addToSendQueue(C09PacketHeldItemChange(mc.thePlayer.inventory.currentItem))
    }

    fun sendC08() {
        mc.netHandler.addToSendQueue(C08PacketPlayerBlockPlacement(BlockPos(-1, -1, -1), 255, mc.thePlayer.currentEquippedItem, 0f, 0f, 0f))
    }

    fun sendC0C() {
        mc.netHandler.addToSendQueue(C0CPacketInput(mc.thePlayer.moveStrafing, mc.thePlayer.moveForward, mc.thePlayer.movementInput.jump, mc.thePlayer.movementInput.sneak))
    }

    fun sendC07NR() {
        mc.netHandler.addToSendQueue(C07PacketPlayerDigging(C07PacketPlayerDigging.Action.RELEASE_USE_ITEM, BlockPos.ORIGIN, EnumFacing.DOWN))
    }

    fun sendC07BR() {
        mc.netHandler.addToSendQueue(C07PacketPlayerDigging(C07PacketPlayerDigging.Action.RELEASE_USE_ITEM, BlockPos(-1, -1, -1), EnumFacing.DOWN))
    }

    fun sendC07ND() {
        mc.netHandler.addToSendQueue(C07PacketPlayerDigging(C07PacketPlayerDigging.Action.DROP_ITEM, BlockPos.ORIGIN, EnumFacing.DOWN))
    }

    fun sendC07BD() {
        mc.netHandler.addToSendQueue(C07PacketPlayerDigging(C07PacketPlayerDigging.Action.DROP_ITEM, BlockPos(-1, -1, -1), EnumFacing.DOWN))
    }
}
