package net.bloom.bloomclient.features.module.modules.movement

import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.movement.fly.GrimFly
import net.bloom.bloomclient.features.module.modules.movement.fly.GrimPacket
import net.bloom.bloomclient.features.module.modules.movement.fly.VanillaFly

object ModuleFly : Module(name = "Fly", description = "Fly", category = ModuleCategory.MOVEMENT) {

    private val mode by mode("Mode", arrayOf(VanillaFly, GrimFly, GrimPacket))

    override fun onEnable() {
        mode.onEnable()
    }

    override fun onDisable() {
        mode.onDisable()
    }


    fun isMoving(): Boolean {
        return mc.thePlayer != null && (mc.thePlayer.movementInput.moveForward != 0f || mc.thePlayer.movementInput.moveStrafe != 0f)
    }

    fun getDirection(): Double {
        var yaw = mc.thePlayer.rotationYaw
        val forward = mc.thePlayer.movementInput.moveForward
        val strafe = mc.thePlayer.movementInput.moveStrafe

        if (forward < 0) yaw += 180f
        val forwardFactor = (if (forward < 0) -0.5f else (if (forward > 0) 0.5f else 1f))

        if (strafe > 0) yaw -= 90 * forwardFactor
        if (strafe < 0) yaw += 90 * forwardFactor

        return yaw.toDouble()
    }
}