package net.bloom.bloomclient.features.module.modules.movement

import net.bloom.bloomclient.event.ReceivedPacketEvent
import net.bloom.bloomclient.event.StrafeEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.player.MovementUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.network.play.server.S12PacketEntityVelocity
import net.minecraft.network.play.server.S3FPacketCustomPayload
import net.minecraft.potion.Potion
import net.minecraft.util.Vector3Pos
import kotlin.math.abs
import kotlin.math.min


object ModuleBloxdPhysics : Module(name = "BloxdPhysics", description = "", category = ModuleCategory.MOVEMENT) {
    private val climb by bool("Climb", true)

    private var jumpfunny = 0.0
    private var jumpticks = System.currentTimeMillis()
    private var wasClimbing = false

    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        val packet = event.packet

        if (packet is S12PacketEntityVelocity && packet.entityID == mc.thePlayer.entityId) {
            jumpticks = System.currentTimeMillis() + 1300
        } else if (packet is S3FPacketCustomPayload && "bloxd:resyncphysics" == packet.channelName) {
            val data = packet.bufferData
            jumpfunny = 0.0
            PhysicPlayer.impulseVector.set(0.0, 0.0, 0.0)
            PhysicPlayer.forceVector.set(0.0, 0.0, 0.0)
            PhysicPlayer.velocityVector.set(data.readFloat().toDouble(), data.readFloat().toDouble(), data.readFloat().toDouble())
        }
    }

    @EventHandler
    fun onStrafe(event: StrafeEvent) {
        mc.thePlayer ?: return

        if (mc.thePlayer.onGround && PhysicPlayer.velocityVector.y < 0)
            PhysicPlayer.velocityVector.set(0.0, 0.0, 0.0)

        if (mc.thePlayer.jumpTicks == 10) {
            jumpfunny = min(jumpfunny + 1, 3.0)
            PhysicPlayer.impulseVector.add(Vector3Pos(0.0, 8.0, 0.0))
        }

        if (climb) {
            if (mc.thePlayer.isCollidedHorizontally && (abs(event.forward) > 0.005f || abs(event.strafe) > 0.005f)) {
                PhysicPlayer.velocityVector.set(0.0, 8.0, 0.0)
                wasClimbing = true
            } else if (wasClimbing) {
                PhysicPlayer.velocityVector.set(0.0, 0.0, 0.0)
                wasClimbing = false
            }
        }

        if (mc.thePlayer.onGroundTicks > 5)
            jumpfunny = 0.0

        var speed = if (jumpticks > System.currentTimeMillis() && mc.timer.timerSpeed == 1f) 1.0
            else if (mc.thePlayer.isUsingItem) 0.06
            else 0.26 + 0.025 * jumpfunny

        if (mc.thePlayer.isPotionActive(Potion.moveSpeed)) {
            val amplifier = mc.thePlayer.getActivePotionEffect(Potion.moveSpeed).amplifier
            speed += amplifier * 0.04 + 0.1
        }

        event.isCancelled = true

        if (mc.theWorld.isBlockLoaded(mc.thePlayer.position)) {
            mc.thePlayer.motionY = PhysicPlayer.tick().y / 30
            MovementUtils.strafe(speed)
        }
    }

    object PhysicPlayer {
        var impulseVector = Vector3Pos(0.0, 0.0, 0.0)
        var forceVector = Vector3Pos(0.0, 0.0, 0.0)
        var velocityVector = Vector3Pos(0.0, 0.0, 0.0)
        private var gravityVector = Vector3Pos(0.0, -10.0, 0.0)

        fun tick(): Vector3Pos {
            // forces
            forceVector.multiplier(1.0)
            // gravity
            forceVector.add(gravityVector)
            forceVector.multiplier(2.0)

            // impulses
            impulseVector.multiplier(1.0)
            forceVector.multiplier(1 / 30.0)

            impulseVector.add(forceVector)
            // velocity
            velocityVector.add(impulseVector)
            forceVector.set(0.0, 0.0, 0.0)
            impulseVector.set(0.0, 0.0, 0.0)

            return velocityVector
        }
    }

}
