package net.bloom.bloomclient.features.module.modules.combat.velocity

import com.viaversion.viabackwards.protocol.v1_19to1_18_2.Protocol1_19To1_18_2
import com.viaversion.viaversion.api.Via
import com.viaversion.viaversion.api.minecraft.BlockPosition
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion
import com.viaversion.viaversion.api.type.Types
import com.viaversion.viaversion.protocols.v1_18_2to1_19.packet.ServerboundPackets1_19
import de.florianmichael.vialoadingbase.ViaLoadingBase
import net.bloom.bloomclient.event.*
import net.bloom.bloomclient.features.component.components.player.MovementCorrection
import net.bloom.bloomclient.features.component.components.player.PacketComponent
import net.bloom.bloomclient.features.component.components.player.RotationComponent
import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.combat.ModuleKillAura
import net.bloom.bloomclient.utils.RandomUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.item.ItemSword
import net.minecraft.network.Packet
import net.minecraft.network.play.INetHandlerPlayClient
import net.minecraft.network.play.client.C03PacketPlayer
import net.minecraft.network.play.client.C07PacketPlayerDigging
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement
import net.minecraft.network.play.server.S12PacketEntityVelocity
import net.minecraft.network.play.server.S27PacketExplosion
import net.minecraft.network.play.server.S32PacketConfirmTransaction
import net.minecraft.util.BlockPos
import net.minecraft.util.EnumFacing
import net.minecraft.util.Rotation
import net.minecraft.util.Vector3Pos
import kotlin.math.sqrt


object SimpleVelocity: Mode("Simple") {
    private val horizontal = float("Horizontal", 0f, -1f, 1f)
    private val vertical = float("Vertical", 0f, 0f, 1f)

    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        val packet = event.packet

        if (packet is S12PacketEntityVelocity) {
            packet.motionX = (packet.motionX * horizontal.get()).toInt()
            packet.motionY = (packet.motionY * vertical.get()).toInt()
            packet.motionZ = (packet.motionZ * horizontal.get()).toInt()
        }
    }
}

object CancelVelocity: Mode("Cancel") {
    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        val packet = event.packet

        if (packet is S12PacketEntityVelocity)
            event.isCancelled = true
    }
}

object Grim117Velocity: Mode("Grim-1.17") {
    private val useC06 by bool("UseC06", true)
    private var canCancel = false

    override fun onEnable() {
        canCancel = false
    }

    @EventHandler
    fun onTick(event: TickEvent) {
        if (canCancel) {
            if (useC06)
                mc.netHandler.addToSendQueue(C03PacketPlayer.C06PacketPlayerPosLook(mc.thePlayer))
            else
                mc.netHandler.addToSendQueue(C03PacketPlayer(mc.thePlayer.onGround))

            mc.netHandler.addToSendQueue(C07PacketPlayerDigging(C07PacketPlayerDigging.Action.STOP_DESTROY_BLOCK, BlockPos(mc.thePlayer), EnumFacing.DOWN))
            canCancel = false
        }
    }

    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        val packet = event.packet

        if (packet is S12PacketEntityVelocity && packet.entityID == mc.thePlayer.entityId && !packet.isSmallVelocity) {
            event.isCancelled = true
            canCancel = true
        } else if (packet is S27PacketExplosion) {
            event.isCancelled = true
            canCancel = true
        }
    }

}

object Test3FMCVelocityMode: Mode("Test3FMC") {
    private var isActive = false
    private var blocking = false

    @EventHandler
    fun onPre(event: MouseInputEvent) {
        mc.thePlayer ?: return
        mc.theWorld ?: return

        val heldItem = mc.thePlayer.heldItem

        when {
            isActive && !blocking && heldItem.item is ItemSword -> {
                mc.playerController.sendUseItem(
                    mc.thePlayer,
                    mc.theWorld,
                    heldItem
                )

                blocking = true
            }

            !isActive && blocking -> {
                mc.playerController.onStoppedUsingItem(mc.thePlayer)

                blocking = false
            }
        }
    }

    @EventHandler
    fun onReceivedPacket(event: PreVelocityEvent) {
        mc.thePlayer ?: return
        mc.theWorld ?: return

        val packet = event.packet
        val heldItem = mc.thePlayer.heldItem

        if (event.entity == mc.thePlayer && event.entity.onGround) {
            if (!packet.isSmallVelocity && heldItem.item is ItemSword)
                isActive = true

            if (blocking) {
                event.isCancelled = true
                isActive = false
            }
        }
    }

}

object HypixelVelocity: Mode("Hypixel") {
    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        val packet = event.packet

        if (packet is S12PacketEntityVelocity && packet.entityID == mc.thePlayer.entityId && mc.thePlayer.onGround) {
            event.isCancelled = true
            mc.thePlayer.motionY = packet.motionY / 8000.0
        }
    }

}

object AttackReduceVelocity: Mode("AttackReduce") {
    private val forward by bool("Forward", true)
    private val reduceY by bool("ReduceY", true)
    private val power by int("Power", 1, 1, 10)
    private val keepSprint by bool("KeepSprint", true)

    @EventHandler
    fun onKnockback(event: KnockbackEvent) {
        event.reduceY = reduceY
        event.power = power
        event.sprint = keepSprint
    }

    @EventHandler
    fun onInput(event: MoveInputEvent) {
        if (forward && mc.objectMouseOver?.entityHit != null && mc.thePlayer.hurtTime > 0)
            event.forward = 1f
    }
}

object JumpVelocity : Mode("Jump") {
    private var jumpState = false

    @EventHandler
    fun onVelocity(event: ReceivedPacketEvent) {
        mc.thePlayer ?: return
        val packet = event.packet

        if (packet is S12PacketEntityVelocity && packet.entityID == mc.thePlayer.entityId) {
            if (mc.thePlayer.onGround && mc.thePlayer.isSprinting) {
                jumpState = true
            }
        }
    }

    @EventHandler
    fun onVelocity(event: PostVelocityEvent) {
        mc.thePlayer ?: return

        if (jumpState) {
            KeyBinding.onTick(KeyBinding.keyBindJump.keyCode)
            jumpState = false
        }
    }
}

object LegitVelocity: Mode("Legit") {
    private var jumpState = false

    @EventHandler
    fun onVelocity(event: ReceivedPacketEvent) {
        mc.thePlayer ?: return
        val packet = event.packet

        if (packet is S12PacketEntityVelocity && packet.entityID == mc.thePlayer.entityId && !packet.isSmallVelocity) {
            if (mc.thePlayer.onGround && mc.thePlayer.isSprinting) {
                jumpState = true
            }
        }
    }

    @EventHandler
    fun onInput(event: UpdateEvent) {
        if (jumpState) {
            mc.thePlayer.tryJump()
            jumpState = false
        }
    }
}

object FightForFapMCVelocity: Mode("3FMC") {

    private val reduceY by bool("ReduceY", true)
    private val power by int("Power", 1, 1, 10)
    private val keepSprint by bool("KeepSprint", true)

    @EventHandler
    fun onKnockback(event: KnockbackEvent) {
        event.reduceY = reduceY
        event.power = power
        event.sprint = keepSprint
    }

    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        mc.thePlayer ?: return

        val packet = event.packet

        if (packet is S12PacketEntityVelocity && packet.entityID == mc.thePlayer.entityId && mc.thePlayer.onGround && ModuleKillAura.currentTarget != null) {
            packet.motionX = 0
            packet.motionZ = 0
        }
    }
}

object GrimLatestVelocity: Mode("GrimLatest") {
    private val stopTicks by int("StopTicks", 6, 1, 25)

    private val packets = mutableListOf<Packet<INetHandlerPlayClient>>()
    private var hasVelocity = false
    private var shouldVelocity = false
    private var ticks = 0

    private var motionX = 0.0
    private var motionY = 0.0
    private var motionZ = 0.0
    private var storeMotion = false

    override fun onEnable() {
        flushPackets()
        hasVelocity = false
    }

    override fun onDisable() {
        flushPackets()
        hasVelocity = false
    }

    @EventHandler
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        mc.thePlayer ?: return

        val packet = event.packet

        if (!shouldVelocity && mc.thePlayer.ticksSinceTeleport >= 3) {
            if (packet is S12PacketEntityVelocity && packet.entityID == mc.thePlayer.entityId) {
                if (!mc.thePlayer.onGround) {
                    packets.add(packet)
                    hasVelocity = true
                } else
                    ticks = stopTicks

                event.isCancelled = true
            }

            if (packet is S32PacketConfirmTransaction && hasVelocity) {
                packets.add(packet)
                event.isCancelled = true
            }
        }
    }

    @EventHandler
    fun onMove(event: MoveEvent) {
        mc.thePlayer ?: return

        if (mc.thePlayer.ticksSinceTeleport < 3) {
            shouldVelocity = true
            ticks = 0
            flushPackets()
            shouldVelocity = false
        }

        if (mc.thePlayer.ticksSinceTeleport >= 3) {
            if (ticks > 0) {
                event.isCancelled = true
                ticks--
            }
        }
    }

    @EventHandler
    fun onStrafe(event: StrafeEvent) {
        mc.thePlayer ?: return

        if (mc.thePlayer.ticksSinceTeleport >= 3) {
            if (mc.thePlayer.onGroundTicks > 3 && mc.thePlayer.onGround && hasVelocity) {
                mc.thePlayer.jump()
            }

            if (ticks > 0) {
                if (!storeMotion) {
                    motionX = mc.thePlayer.motionX
                    motionY = mc.thePlayer.motionY
                    motionZ = mc.thePlayer.motionZ
                    storeMotion = true
                }
            } else if (storeMotion) {
                mc.thePlayer.motionX = motionX
                mc.thePlayer.motionY = motionY
                mc.thePlayer.motionZ = motionZ
                storeMotion = false
            }
        }
    }

    @EventHandler
    fun onJump(event: JumpEvent) {
        mc.thePlayer ?: return

        if (mc.thePlayer.ticksSinceTeleport >= 3) {
            if (mc.thePlayer.offGroundTicks > 25 && hasVelocity) {
                hasVelocity = false
                shouldVelocity = true
                flushPackets()
                shouldVelocity = false
            }

            if (mc.thePlayer.onGround && hasVelocity) {
                ticks = stopTicks + 1
                hasVelocity = false
                shouldVelocity = true
//                PingSpoofComponent.dispatch()

                val lastMotionVector = Vector3Pos(mc.thePlayer.motionX, mc.thePlayer.motionY, mc.thePlayer.motionZ)
                flushPackets()
                mc.thePlayer.motionX = lastMotionVector.x
                mc.thePlayer.motionZ = lastMotionVector.y
                mc.thePlayer.motionY = lastMotionVector.z
                shouldVelocity = false
            }
        }
    }

    @EventHandler(priority = -999)
    fun onPlayerRotation(event: PlayerRotationEvent) {
        if (ticks > 0)
            RotationComponent.setRotation(Rotation(mc.thePlayer.playerYaw, RandomUtils.nextFloat(89f, 90f)), 10f, 10f, fixType = MovementCorrection.Type.NORMAL)
    }

    @EventHandler
    fun onTick(event: TickEvent) {
        if (ticks <= 0)
            return

        val blockPos = BlockPos(mc.thePlayer)
        val downBlockPos = blockPos.down()

        val x = mc.thePlayer.posX.toFloat() - blockPos.x
        val y = 1.0f
        val z = mc.thePlayer.posZ.toFloat() - blockPos.z

        if (ViaLoadingBase.getInstance().getTargetVersion() >= ProtocolVersion.v1_19) {
            val userConnection = Via.getManager().connectionManager.connections.first()
            val packet = PacketWrapper.create(ServerboundPackets1_19.USE_ITEM_ON, userConnection)

            packet.write(Types.VAR_INT, 0)
            packet.write(Types.BLOCK_POSITION1_14, BlockPosition(downBlockPos.x, downBlockPos.y, downBlockPos.z))
            packet.write(Types.VAR_INT, EnumFacing.UP.ordinal)
            packet.write(Types.FLOAT, x)
            packet.write(Types.FLOAT, y)
            packet.write(Types.FLOAT, z)
            packet.write(Types.BOOLEAN, false)
            packet.write(Types.VAR_INT, mc.playerController.nextTickPlayerController)

            packet.sendToServer(Protocol1_19To1_18_2::class.java)
        } else {
            mc.netHandler.addToSendQueue(C08PacketPlayerBlockPlacement(downBlockPos, EnumFacing.UP.getIndex(), mc.thePlayer.heldItem, x, y, z))
        }
    }

    private fun flushPackets() {
        packets.forEach { PacketComponent.processPacket(it) }
        packets.clear()
    }

}