package net.bloom.bloomclient.features.module.modules.combat.killaura.randomizedaimvector

import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.combat.ModuleKillAura
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.player.RotationUtils
import net.minecraft.util.Vec3
import net.minecraft.util.VectorRotation
import java.security.SecureRandom

abstract class RandomizedAimVectorMode(mode: String): Mode(mode) {
    abstract fun randomize(vectorRotation: VectorRotation): VectorRotation
}

object NoRandomizedAimVectorMode: RandomizedAimVectorMode("None") {
    override fun randomize(vectorRotation: VectorRotation) = vectorRotation
}

object NormalRandomizedAimVectorMode: RandomizedAimVectorMode("Normal") {
   val chance = float("Chance", 0.5f, 0f, 1f)

    override fun randomize(vectorRotation: VectorRotation): VectorRotation {
        val x = RandomUtils.nextDouble(0.0, 0.4) - 0.2
        val y = RandomUtils.nextDouble()
        val z = RandomUtils.nextDouble(0.0, 0.4) - 0.2

        return if(SecureRandom.getInstanceStrong().nextDouble() < chance.get()){
            RotationUtils.calculateRotationFromVector(vectorRotation.entity, Vec3(x, y, z), ModuleKillAura.range) ?: vectorRotation
        } else {
            vectorRotation
        }
    }
}

object SecureRandomRandomizedAimVectorMode: RandomizedAimVectorMode("SecureRandom") {
    private val chance = float("Chance", 0.5f, 0f, 1f)

    override fun randomize(vectorRotation: VectorRotation): VectorRotation {
        val x = SecureRandom.getInstanceStrong().nextDouble(0.0, 0.4) - 0.2
        val y = SecureRandom.getInstanceStrong().nextDouble(0.0, 0.1) - 0.1
        val z = SecureRandom.getInstanceStrong().nextDouble(0.0, 0.4) - 0.2

        return if(SecureRandom.getInstanceStrong().nextDouble() < chance.get()){
            RotationUtils.calculateRotationFromVector(vectorRotation.entity, Vec3(x, y, z), ModuleKillAura.range) ?: vectorRotation
        } else {
            vectorRotation
        }
    }
}