package net.bloom.bloomclient.features.module.modules.combat.killaura.aimvector

import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.combat.ModuleKillAura
import net.bloom.bloomclient.utils.player.RotationUtils
import net.minecraft.entity.EntityLivingBase
import net.minecraft.util.Vec3
import net.minecraft.util.VectorRotation

abstract class AimVectorMode(mode: String): Mode(mode) {
    abstract fun getVectorRotation(entity: EntityLivingBase): VectorRotation
}

object NormalAimVectorMode: AimVectorMode("Normal") {
    override fun getVectorRotation(entity: EntityLivingBase): VectorRotation {
        val vector = RotationUtils.clampVecInBoundingBox(mc.thePlayer.getPositionEyes(1f), entity.entityBoundingBox)

        val rotation = RotationUtils.toRotation(vector)
        return VectorRotation(entity, vector, rotation)
    }
}

object BruteforceAimVectorMode: AimVectorMode("Bruteforce") {
    private val vectorRangeX by floatRange("VectorRangeX", 0f, 1f, 0f, 1f)
    private val vectorStepX by float("VectorStepX", 0.1f, 0.1f, 1f)
    private val vectorRangeY by floatRange("VectorRangeY", 0f, 1f, 0f, 1f)
    private val vectorStepY by float("VectorStepY", 0.1f, 0.1f, 1f)
    private val vectorRangeZ by floatRange("VectorRangeZ", 0f, 1f, 0f, 1f)
    private val vectorStepZ by float("VectorStepZ", 0.1f, 0.1f, 1f)

    override fun getVectorRotation(entity: EntityLivingBase): VectorRotation {
        var currentVectorRotation = NormalAimVectorMode.getVectorRotation(entity)

        for (x in vectorRangeX.getValueRangeDouble(vectorStepX.toDouble())) {
            for (y in vectorRangeY.getValueRangeDouble(vectorStepY.toDouble())) {
                for (z in vectorRangeZ.getValueRangeDouble(vectorStepZ.toDouble())) {
                    val vectorRotation = RotationUtils.calculateRotationFromVector(entity, Vec3(x, y, z), ModuleKillAura.range) ?: continue
                    if (RotationUtils.getRotationDifference(vectorRotation.rotation) < RotationUtils.getRotationDifference(currentVectorRotation.rotation))
                        currentVectorRotation = vectorRotation
                }
            }
        }

       return currentVectorRotation
    }
}

object CenterAimVectorMode: AimVectorMode("Center") {
    override fun getVectorRotation(entity: EntityLivingBase): VectorRotation {
        return RotationUtils.calculateRotationFromVector(entity, Vec3(0.5, 0.5, 0.5), ModuleKillAura.range) ?: NormalAimVectorMode.getVectorRotation(entity)
    }
}
