package net.bloom.bloomclient.features.module.modules.combat.autoclicker

import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.combat.ModuleAutoClicker
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.struct.MSTimer

open class AutoClickerMode(name: String): Mode(name) {

    open fun handleRightClick() {}

    open fun handleLeftClick() {}

}

object NormalAutoClicker: AutoClickerMode("Normal") {
    private val clicksValue = intRange("Clicks", 20, 20, 1, 30)

    private var leftClickDelay = 0L
    private val leftClickTimer = MSTimer()

    private var rightClickDelay = 0L
    private val rightClickTimer = MSTimer()

    override fun handleLeftClick() {
        if (leftClickTimer.hasTimePassed(leftClickDelay)) {
            ModuleAutoClicker.click(rightClick = false)

            val nextClicks = RandomUtils.nextInt(clicksValue.value.minimum, clicksValue.value.maximum)
            println(nextClicks)
            leftClickDelay = 1000L / nextClicks
            leftClickTimer.reset()
        }
    }

    override fun handleRightClick() {
        if (rightClickTimer.hasTimePassed(rightClickDelay)) {
            ModuleAutoClicker.click(rightClick = true)

            val nextClicks = RandomUtils.nextInt(clicksValue.value.minimum, clicksValue.value.maximum)
            rightClickDelay = 1000L / nextClicks
            rightClickTimer.reset()
        }
    }

}

object DragClickAutoClicker: AutoClickerMode("DragClick") {
    private val delay = intRange("Delay", 17, 18, 1, 50)
    private val length = intRange("Length", 6, 6, 1, 20)

    private var nextLength = 0
    private var nextDelay = 0

    override fun handleRightClick() {
        if (nextLength < 0) {
            nextDelay--
            if (nextDelay < 0) {
                nextDelay = RandomUtils.nextInt(delay.value.minimum, delay.value.maximum)
                nextLength = RandomUtils.nextInt(length.value.minimum, length.value.maximum)
            }
        } else if (Math.random() < 0.95) {
            nextLength--
            ModuleAutoClicker.click(true)
        }
    }
}