package net.bloom.bloomclient.features.module.modules.combat

import de.florianmichael.viamcp.fixes.AttackOrder
import net.bloom.bloomclient.event.TickEvent
import net.bloom.bloomclient.event.TimerEvent
import net.bloom.bloomclient.event.WorldEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.world.ModuleScaffold
import net.bloom.bloomclient.utils.player.MovementUtils
import net.bloom.bloomclient.utils.struct.MSTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.entity.EntityLivingBase
import net.minecraft.util.MathHelper
import java.io.IOException
import kotlin.math.abs
import kotlin.math.ceil
import kotlin.math.round
import kotlin.math.sqrt

object ModuleTimerRange : Module(name = "TimerRange", category = ModuleCategory.COMBAT, description = "Allows you to teleport to player") {
    private val range = floatRange("Range", 3f, 3f, 3f, 6f)
    private val instantTimer = bool("FastTimer", false)
    private val maxTimer = float("Timer", 10.0f, 1.0f, 10.0f) { !instantTimer.get() }
    private var slowTimer = float("SlowTimer", 0f, 0f, 1f)
    private val chargeMultiplier = float("ChargeMultiplier", 1.0f, 0.0f, 1.0f)
    private var delay = int("Delay", 200, 0, 3000)
    private var notInCombo = bool("NotInCombo", true)
    private var onlyForward = bool("OnlyMoveForward", true)
    private val post = bool("Post", false)
    private var onlyOnGround = bool("OnlyOnGround", false)
    private var noFluid = bool("NoFluid", true)

    private var balance = 0.0
    private var lastBalance = 0.0
    private var smartMaxBalance = 0.0
    private var fast = false
    private var target: EntityLivingBase? = null
    private val delayTimer = MSTimer()

    override val tag: String
        get() = "${range.value.minimum} - ${range.value.maximum}"

    override fun onEnable() {
        delayTimer.reset()
    }

    override fun onDisable() {
        mc.timer.timerSpeed = 1.0f
    }

    @EventHandler
    fun onWorldChange(e: WorldEvent) {
        balance = 0.0
        lastBalance = 0.0
    }

    @EventHandler
    fun onTick(e: TickEvent) {
        if (!ModuleScaffold.state) {
            balance += when {
                post.get() -> if (mc.timer.timerSpeed != 1.0f) chargeMultiplier.get() else 1.0f
                fast -> chargeMultiplier.get()
                else -> 1.0f
            }
        }
    }

    @EventHandler
    fun onTickDelay(e: TimerEvent) {
        if (!ModuleScaffold.state) {
            balance--
        }

        if (mc.thePlayer != null && mc.theWorld != null && ModuleKillAura.state && !ModuleScaffold.state && mc.thePlayer.ticksExisted >= 10)
        {
            target = ModuleKillAura.currentTarget

            if (target != null && outOfRange()) {
                target = null
            }

            if (fast) {
                handleFastMode()
            }

            if (!fast) {
                handleNormalMode()
            }

            if (mc.thePlayer.ticksExisted <= 20) {
                mc.timer.timerSpeed = 1.0f
            }
        } else {
            if (!ModuleScaffold.state) {
                mc.timer.timerSpeed = 1.0f
            }
            target = null
        }
    }

    private fun handleFastMode() {
        if (post.get()) {
            if (balance < lastBalance) {
                processFastModeLogic()
            } else {
                resetFastMode()
            }
        } else {
            if (balance < smartMaxBalance + lastBalance) {
                processFastModeLogic()
            } else {
                resetFastMode()
            }
        }
    }

    private fun processFastModeLogic() {
        if (target != null) {
            if (!isTargetCloseOrVisible()) {
                if (isHurtTime()) {
                    if (instantTimer.get()) {
                        try {
                            var shouldStop = false
                            while (!shouldStop) {
                                val condition = when {
                                    post.get() -> balance >= lastBalance || shouldStop()
                                    else -> shouldStop() || balance >= smartMaxBalance + lastBalance
                                }

                                if (condition) {
                                    shouldStop = true
                                    delayTimer.reset()
                                    resetFastModeWithAttack()
                                }

                                if (!shouldStop) {
                                    debug("Run Tick")
                                    mc.runTick()
                                    balance += chargeMultiplier.value
                                }
                            }

                            debug("Stop")
                        } catch (e: IOException) {
                            e.printStackTrace()
                        }
                    } else {
                        mc.timer.timerSpeed = maxTimer.get()
                        debug("Run Timer")

                        if (shouldStop() && fast) {
                            mc.timer.timerSpeed = 1.0f
                            fast = false
                            debug("Stop")
                            if (post.get()) {
                                delayTimer.reset()
                            }
                        }
                    }
                } else if (!post.get()) {
                    resetFastMode()
                }
            } else {
                resetFastModeWithAttack()
            }
        } else {
            resetFastMode()
        }
    }

    private fun resetFastMode() {
        mc.timer.timerSpeed = 1.0f
        fast = false
        if (post.get()) {
            delayTimer.reset()
        }
    }

    private fun resetFastModeWithAttack() {
        resetFastMode()

        mc.entityRenderer.getMouseOver(1.0F)

        if (mc.objectMouseOver.entityHit == target) {
            AttackOrder.sendFixedAttack(mc.thePlayer, target, true)
        }
    }

    private fun handleNormalMode() {
        if (post.get()) {
            handlepostNormalMode()
        } else {
            handleRegularNormalMode()
        }
    }

    private fun handlepostNormalMode() {
        if (!delayTimer.hasTimeElapsed(delay.get(), false)) return

        if (target != null) {
            if (!shouldStop() && (mc.timer.timerSpeed == 1.0f || mc.timer.timerSpeed == slowTimer.get())) {
                setSmartBalance()
            }

            when {
                !isTargetCloseOrVisible() && isHurtTime() -> {
                    if (balance > lastBalance - smartMaxBalance) {
                        if (shouldStop()) {
                            if (mc.timer.timerSpeed != slowTimer.get()) {
                                lastBalance = balance
                            }
                            mc.timer.timerSpeed = 1.0f
                            return
                        }
                        mc.timer.timerSpeed = slowTimer.get()
                    } else {
                        fast = true
                        mc.timer.timerSpeed = 1.0f
                    }
                }
                else -> {
                    if (mc.timer.timerSpeed != slowTimer.get()) {
                        lastBalance = balance
                    }
                    mc.timer.timerSpeed = 1.0f
                }
            }
        } else {
            if (mc.timer.timerSpeed != slowTimer.get()) {
                lastBalance = balance
            }
            mc.timer.timerSpeed = 1.0f
        }
    }

    private fun handleRegularNormalMode() {
        if (balance > lastBalance) {
            mc.timer.timerSpeed = slowTimer.get()
        } else {
            if (mc.timer.timerSpeed == slowTimer.get()) {
                mc.timer.timerSpeed = 1.0f
            }

            if (!delayTimer.hasTimeElapsed(delay.get(), false)) return

            if (target != null && !isTargetCloseOrVisible() && isHurtTime()) {
                setSmartBalance()
                fast = true
                delayTimer.reset()
                lastBalance = balance
            }
        }
    }
    
    private fun setSmartBalance() {
        val distance = mc.thePlayer.getDistanceToEntityBox(target) + targetMovementAdjust()
        if (target == null) {
            smartMaxBalance = 0.0
        } else if (shouldStop()) {
            smartMaxBalance = 0.0
        } else {
            val playerBPS = maxOf(MovementUtils.baseMoveSpeed / 1.2, mc.thePlayer.speed)
            val finalDistance = distance - 3.0
            smartMaxBalance = if (!post.get()) {
                ceil(finalDistance / playerBPS)
            } else {
                val targetMotionX = abs(target!!.lastTickPosX - target!!.posX)
                val targetMotionZ = abs(target!!.lastTickPosZ - target!!.posZ)
                val targetBPS = if (sqrt(targetMotionX * targetMotionX + targetMotionZ * targetMotionZ) <= 0.1) {
                    sqrt(targetMotionX * targetMotionX + targetMotionZ * targetMotionZ)
                } else {
                    MovementUtils.baseMoveSpeed
                }
                round(finalDistance / (playerBPS + targetBPS))
            }
        }
    }

    
    private fun shouldStop(): Boolean {
        var stop = false

        if (target == null) {
            return true
        }

        val predictX = mc.thePlayer.posX + (mc.thePlayer.posX - mc.thePlayer.lastTickPosX) * 2.0
        val predictZ = mc.thePlayer.posZ + (mc.thePlayer.posZ - mc.thePlayer.lastTickPosZ) * 2.0
        val f = (predictX - target!!.posX).toFloat()
        val f1 = (mc.thePlayer.posY - target!!.posY).toFloat()
        val f2 = (predictZ - target!!.posZ).toFloat()
        val predictedDistance = MathHelper.sqrt_float(f * f + f1 * f1 + f2 * f2).toDouble()

        if (onlyOnGround.get() && !mc.thePlayer.onGround) {
            stop = true
        }

        if (mc.thePlayer.getDistanceToEntityBox(target) <= range.value.minimum) {
            if (post.get()) {
                if (!fast) {
                    stop = true
                }
            } else if (!fast && mc.timer.timerSpeed != slowTimer.get()) {
                stop = true
            }
        }

        if (isTargetCloseOrVisible()) {
            stop = true
        }

        if (!isHurtTime()) {
            stop = true
        }

        if (outOfRange()) {
            stop = true
        }

        if ((mc.thePlayer.speed <= 0.12 || !KeyBinding.keyBindForward.isKeyDown || predictedDistance > mc.thePlayer.getDistanceToEntity(target) + 0.12) && onlyForward.get()) {
            stop = true
        }

        if (noFluid.get() && (mc.thePlayer.isInWater || mc.thePlayer.isInLava || mc.thePlayer.isInWeb)) {
            stop = true
        }

        if (mc.thePlayer.getDistance(target!!.lastTickPosX, target!!.lastTickPosY, target!!.lastTickPosZ) <
            mc.thePlayer.getDistance(target!!.posX, target!!.posY, target!!.posZ)) {
            stop = notInCombo.get()
            if (post.get() && !fast) {
                stop = false
            }
        }

        return stop
    }

    private fun outOfRange(): Boolean {
        return mc.thePlayer.getDistanceToEntityBox(target) > range.value.maximum + targetMovementAdjust()
    }

    private fun targetMovementAdjust(): Double {
        val entity = target ?: return 0.0
        val targetIsSprinting = entity.isSprinting
        val playerIsSprinting = mc.thePlayer.isSprinting

        val walkingSpeed = 0.10000000149011612
        val targetSpeed = if (targetIsSprinting) 1.25 else walkingSpeed
        val playerSpeed = if (playerIsSprinting) 1.25 else walkingSpeed

        val targetPredictedX = (entity.posX - entity.prevPosX) * targetSpeed
        val targetPredictedY = (entity.posY - entity.prevPosY) * targetSpeed
        val targetPredictedZ = (entity.posZ - entity.prevPosZ) * targetSpeed

        val playerPredictedX = (mc.thePlayer.posX - mc.thePlayer.prevPosX) * playerSpeed
        val playerPredictedY = (mc.thePlayer.posY - mc.thePlayer.prevPosY) * playerSpeed
        val playerPredictedZ = (mc.thePlayer.posZ - mc.thePlayer.prevPosZ) * playerSpeed

        if (
            targetPredictedX != 0.0 && targetPredictedZ != 0.0 && targetPredictedY != 0.0 ||
            playerPredictedX != 0.0 && playerPredictedY != 0.0 && playerPredictedZ != 0.0
        ) {
            val x = targetPredictedX + playerPredictedX
            val y = targetPredictedY + playerPredictedY
            val z = targetPredictedZ + playerPredictedZ

            val predicted = sqrt(x * x + y * y + z * z)

            debug("Predict Range:$predicted")

            return predicted
        }

        return 0.0
    }

    private fun isTargetCloseOrVisible(): Boolean {
        val target = target ?: return false
        return mc.thePlayer.getDistance(target.posX, target.posY, target.posZ) <= 3.0
    }

    private fun isHurtTime(): Boolean {
        if (post.get()) {
            val distance = mc.thePlayer.getDistanceToEntityBox(target) + targetMovementAdjust()
            val playerBPS = maxOf(MovementUtils.baseMoveSpeed / 1.1, mc.thePlayer.speed)
            val finalDistance = distance - 3.0
            val targetMotionX = abs(target!!.lastTickPosX - target!!.posX)
            val targetMotionZ = abs(target!!.lastTickPosZ - target!!.posZ)
            val targetBPS = maxOf(MovementUtils.baseMoveSpeed / 1.1, sqrt(targetMotionX * targetMotionX + targetMotionZ * targetMotionZ))
            val hurtTime = finalDistance / (playerBPS + targetBPS * 1.1)
            return mc.thePlayer.hurtTime <= hurtTime
        }
        return mc.thePlayer.hurtTime <= 1
    }
}