package net.bloom.bloomclient.features.module.modules.combat

import net.bloom.bloomclient.event.*
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.struct.MSTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.entity.EntityLivingBase
import net.minecraft.network.play.client.C0BPacketEntityAction


object ModuleSuperKnockback : Module(name = "Knockback", description = "Helps you get people in combos", category = ModuleCategory.COMBAT) {
    private val mode = list("Mode", "WTap", arrayOf("WTap", "Legit", "LegitFast", "Stap", "StartPacket", "Packet", "PacketLegit", "DoublePacket"))
    private val delayValue = floatRange("Delay", 50f, 50f, 0f, 500f) { mode.get().lowercase() == "legit" }
    private val hurtTimeDelay = bool("HurtTimeDelay", true)
    private val hurtTimeValue = int("HurtTimeValue", 10, 0 ,10) { hurtTimeDelay.get() }
    private var isHit = false
    private var attackDelay = MSTimer()
    private var delay = 0f

    override fun onEnable() {
        attackDelay.reset()
        isHit = false
    }

    override fun onDisable() {
        attackDelay.reset()
        isHit = false
    }

    @EventHandler
    fun onUpdate(event: UpdateEvent){
        if (mode.get().equals("legitfast", true) && isHit) {
            if(mc.thePlayer.serverSprintState) {
                mc.thePlayer.sprintingTicksLeft = 0
                debug("Do Reset Sprint")
            }

            isHit = false
        }
    }

    @EventHandler
    fun onForward(event: MoveForwardEvent) {
        if (mode.get().equals("wtap", true) && isHit) {
            if(mc.thePlayer.serverSprintState) {
                event.reset = true
                debug("Do Reset Sprint")
            }

            isHit = false
        }
    }

    @EventHandler
    fun onPostSprint(event: PostSprintEvent) {
        if (mode.get().equals("legit", true) && attackDelay.hasTimePassed(delay)) {
            if (isHit) {
                if(mc.thePlayer.serverSprintState) {
                    mc.thePlayer.isSprinting = false
                    debug("Do Reset Sprint")
                }

                isHit = false
            }

            delay = RandomUtils.nextFloat(delayValue.value.minimum, delayValue.value.maximum)
            attackDelay.reset()
        }
    }

    @EventHandler
    fun onAttack(event: AttackEvent) {
        val target = event.target

        if (!KeyBinding.keyBindForward.isKeyDown || mc.thePlayer.isSneaking)
            return

        if (target is EntityLivingBase && (target.hurtTime == hurtTimeValue.get() || !hurtTimeDelay.get()) ) {
            when (mode.get().lowercase()) {
                "legit", "legitfast", "wtap" -> {
                    isHit = true
                }

                "packetlegit" -> if(mc.thePlayer.isSprinting){
                    if (!mc.thePlayer.serverSprintState) {
                        mc.netHandler.addToSendQueue(C0BPacketEntityAction(mc.thePlayer, C0BPacketEntityAction.Action.START_SPRINTING))
                        mc.thePlayer.serverSprintState = true
                    }
                }

                "startpacket" -> {
                    mc.thePlayer.sendStartSprintingPacket()
                    mc.thePlayer.serverSprintState = true
                }

                "packet" -> {
                    mc.thePlayer.sendStopSprintingPacket()
                    mc.thePlayer.sendStartSprintingPacket()
                    mc.thePlayer.serverSprintState = true
                }

                "doublepacket" -> {
                    repeat(2) {
                        mc.thePlayer.sendStopSprintingPacket()
                        mc.thePlayer.sendStartSprintingPacket()
                    }
                    mc.thePlayer.serverSprintState = true
                }
            }
        }
    }

    @EventHandler
    fun onMoveInput(event: MoveInputEvent) {
        val entity = mc.objectMouseOver?.entityHit ?: return

        if (entity is EntityLivingBase){
            if (mode.get().equals("stap", true)) {
                event.forward = when (entity.hurtTime) {
                    10 -> -1f
                    9 -> 1f
                    else -> return
                }
            }
        }
    }

    override val tag: String
        get() = mode.get()
}
