package net.bloom.bloomclient.features.module.modules.combat

import net.bloom.bloomclient.event.*
import net.bloom.bloomclient.features.component.components.player.PacketComponent.sendPackets
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.combat.ModuleKillAura.priority
import net.bloom.bloomclient.features.module.modules.world.ModuleScaffold
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.network.TimedPacket
import net.bloom.bloomclient.utils.player.EntityUtils
import net.bloom.bloomclient.utils.player.RotationUtils.getDistanceToEntityBox
import net.bloom.bloomclient.utils.render.RenderUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.GameStorage
import net.minecraft.client.multiplayer.WorldClient
import net.minecraft.entity.EntityLivingBase
import net.minecraft.network.play.client.C03PacketPlayer
import net.minecraft.util.Vec3
import java.awt.Color

object ModuleLagRange : Module(
    name = "LagRange",
    description = "Uses blink to give you reach while protecting from counterattacks",
    category = ModuleCategory.COMBAT
) {
    // Settings
    private val delay = intRange("Delay", 150, 200, 0, 1000)
    private val esp = bool("ESP", true)
    private val discoveredRange: Float by float("DiscoveredRange", 4f, 3f, 16f)
    private val color = Color(72, 125, 227)
    private var lastWorld: WorldClient? = null
    private var dynamicDelay = 0
    private var lastDelayAdjustment = 0L
    private var entity: EntityLivingBase? = null
    private var enabled = false
    private var ignoreWholeTick = false
    private val outgoingPackets = mutableListOf<TimedPacket>()

    override fun onEnable() {
        blink()
    }
    @EventHandler
    fun onPreUpdate(event: PreUpdateEvent){
        enabled = !mc.isSingleplayer
    }
    @EventHandler
    fun onRender(event: Render3DEvent) {
        mc.thePlayer ?: return
        mc.theWorld ?: return

        synchronized(outgoingPackets) {
            for (timedPacket in outgoingPackets.toList()) {
                val packet = timedPacket.packet

                if(packet is C03PacketPlayer && GameStorage.thirdPersonView != 0 && esp.get()){
                    RenderUtils.drawPosByVec(Vec3(packet), color)
                }
            }
        }
    }

    @EventHandler(priority = -5)
    fun onPacket(e: SentPacketEvent) {
        if (!enabled) return
        val packet = e.packet

        if(packet.reuseable)
            return

        if (mc.thePlayer == null || mc.theWorld == null || mc.netHandler.networkManager.netHandler == null || ignoreWholeTick) {
            blink()
            return
        }

        if (ModuleScaffold.state) {
            blink()
            return
        }

        entity = null

        val foundEntities = mutableListOf<EntityLivingBase>()

        for (entity in mc.theWorld.loadedEntityList) {
            if (entity is EntityLivingBase && EntityUtils.isSelected(entity, true) && getDistanceToEntityBox(entity) <= discoveredRange)
                foundEntities.add(entity)
        }

        when (priority.lowercase()) {
            "health" -> foundEntities.sortBy { it.effectiveHealth }
            "distance" -> foundEntities.sortBy { getDistanceToEntityBox(it) }
        }

        entity = foundEntities.firstOrNull()

        if (mc.theWorld != null && lastWorld != mc.theWorld) {
            blink()
            lastWorld = mc.theWorld
        } else {
            if (entity != null && mc.thePlayer.getDistanceToEntity(entity) in 3F..discoveredRange) {
                synchronized(outgoingPackets) {
                    e.stopRunEvent = true
                    e.isCancelled = true
                    packet.reuseable = true

                    outgoingPackets.add(TimedPacket(packet))
                }
            } else {
                blink()
            }
        }
    }

    private fun blink() {
        mc.addScheduledTask {
            handlePackets(true)
            ignoreWholeTick = true
        }
    }

    @EventHandler
    fun onGameLoop(event: GameLoopEvent) {
        mc.thePlayer ?: return
        handlePackets()
        ignoreWholeTick = false
    }

    private fun handlePackets(clear: Boolean = false){
        synchronized(outgoingPackets) {
            for (timedPacket in outgoingPackets.toList()) {
                if (System.currentTimeMillis() - lastDelayAdjustment > 1000) {
                    dynamicDelay = RandomUtils.nextInt(delay.value.minimum, delay.value.maximum + 1)
                    lastDelayAdjustment = System.currentTimeMillis()
                }

                if (System.currentTimeMillis() - timedPacket.time > dynamicDelay || clear) {
                    sendPackets(timedPacket.packet)
                    outgoingPackets.remove(timedPacket)
                }
            }
        }
    }
}