package net.bloom.bloomclient.features.module.modules.combat

import de.florianmichael.viamcp.fixes.AttackOrder
import net.bloom.bloomclient.event.*
import net.bloom.bloomclient.features.component.components.player.MovementCorrection
import net.bloom.bloomclient.features.component.components.player.PacketComponent.sendPacket
import net.bloom.bloomclient.features.component.components.player.RotationComponent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.combat.killaura.aimvector.BruteforceAimVectorMode
import net.bloom.bloomclient.features.module.modules.combat.killaura.aimvector.CenterAimVectorMode
import net.bloom.bloomclient.features.module.modules.combat.killaura.aimvector.NormalAimVectorMode
import net.bloom.bloomclient.features.module.modules.combat.killaura.randomizedaimvector.NoRandomizedAimVectorMode
import net.bloom.bloomclient.features.module.modules.combat.killaura.randomizedaimvector.NormalRandomizedAimVectorMode
import net.bloom.bloomclient.features.module.modules.combat.killaura.randomizedaimvector.SecureRandomRandomizedAimVectorMode
import net.bloom.bloomclient.features.module.modules.combat.killaura.randomizedrotation.MullerBoxRandomized
import net.bloom.bloomclient.features.module.modules.combat.killaura.randomizedrotation.NoRandomizedRotationMode
import net.bloom.bloomclient.features.module.modules.combat.killaura.randomizedrotation.NoiseRandomizedRotationMode
import net.bloom.bloomclient.features.shared.randomizedclicker.LegitClickerMode
import net.bloom.bloomclient.features.shared.randomizedclicker.MultiplierRandomizedClickerMode
import net.bloom.bloomclient.features.shared.randomizedclicker.NoRandomizedClickerMode
import net.bloom.bloomclient.features.shared.rotationspeed.HumanizedRotationSpeedMode
import net.bloom.bloomclient.features.shared.rotationspeed.LinearRotationSpeedMode
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.player.EntityUtils
import net.bloom.bloomclient.utils.player.RotationUtils
import net.bloom.bloomclient.utils.struct.MSTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.gui.inventory.GuiInventory
import net.minecraft.client.input.MouseHandler
import net.minecraft.entity.EntityLivingBase
import net.minecraft.item.ItemSword
import net.minecraft.network.play.client.C03PacketPlayer.C06PacketPlayerPosLook
import net.minecraft.network.play.client.C07PacketPlayerDigging
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement
import net.minecraft.util.BlockPos
import net.minecraft.util.EnumFacing
import net.minecraft.util.MovingObjectPosition
import net.minecraft.util.Vec3
import kotlin.math.roundToLong

object ModuleKillAura : Module(
    name = "KillAura",
    description = "Attack entity around you.",
    category = ModuleCategory.COMBAT
) {
    /* Clicking */
    private val combatModeObject = list("CombatMode", "1.8", arrayOf("1.8", "1.9+"))
    private val combatMode by combatModeObject
    private val cpsAlgorithmObject = mode("CPSAlgorithm", arrayOf(
        NoRandomizedClickerMode(),
        LegitClickerMode(),
        MultiplierRandomizedClickerMode()
    )) { combatMode.equals("1.8", true) }
    private val clickModeObject = list("ClickMode", "Packet", arrayOf("Packet", "Mouse"))
    private val clickMode by clickModeObject

    private val cpsAlgorithm by cpsAlgorithmObject
    private val cpsGroup = group("CPSGroup", arrayOf(combatModeObject, cpsAlgorithmObject, clickModeObject))

    /* Range */
    private val attackRange: Float by float("AttackRange", 3f, 3f, 8f).onPreChange { _, newValue ->
        if (clickMode == "Mouse") newValue.coerceAtMost(clickRange) else newValue.coerceAtMost(discoveredRange)
    }

    private val clickRange: Float by float("ClickRange", 3f, 3f, 8f) { clickMode.equals("mouse", true) }.onPreChange { _, newValue ->
        newValue.coerceAtMost(discoveredRange)
    }
    private val throughWallsRange by float("ThroughWallsRange", 0f, 0f, 8f).onPreChange { _, newValue ->
        newValue.coerceAtMost(attackRange)
    }
    val discoveredRange: Float by float("DiscoveredRange", 4f, 3f, 16f).onPreChange { _, newValue ->
        if (clickMode == "Mouse") newValue.coerceAtLeast(clickRange) else newValue.coerceAtLeast(attackRange)
    }

    private val viaFixes by bool("ViaFix", true)
    private val grimexploit by bool("OldGrim117Exploit", false)
    private val checkInventory by bool("CheckInventory", true)
    private val raycastMode by list("RaycastMode", "Legit", arrayOf("Legit", "ThroughWalls", "None"))

    /* Target */
    private val targetMode by list("TargetMode", "Single", arrayOf("Single", "Switch"))
    private val switchDelayValue by int("SwitchDelay", 300, 0, 1000) { targetMode.equals("switch", true) }

    /* Priority */
    val priority by list("Priority", "Health", arrayOf("Health", "Distance"))

    /* AutoBlock */
    val autoBlock by bool("AutoBlock", true)
    private val autoBlockRange by float("AutoBlockRange", 5f, 0f, 8f) { autoBlock }.onPostChange { _, newValue ->
        newValue.coerceAtMost(discoveredRange)
    }

    private val autoBlockTiming by list("AutoBlockTiming", "Pre", arrayOf("Pre", "Post")) { autoBlock }
    private val releaseBlocking by bool("ReleaseBlocking", true)
    private val releaseBlockingTiming by list("ReleaseBlockingTiming", "Post", arrayOf("Pre", "Post")) { autoBlock && releaseBlocking }
    private val autoBlockMode by list("AutoBlockMode", "Vanilla", arrayOf("Vanilla", "NCP", "AAC", "Interact", "Grim", "Intave", "RightClick", "Fake")) { autoBlock }

    /* Rotation */
    private val dontCalculateNewRotationIfPlayerFacingOnTarget by bool("DontCalculateNewRotationIfPlayerFacingOnTarget", true)
    private val aimVectorMode by mode("AimVector", arrayOf(NormalAimVectorMode, BruteforceAimVectorMode, CenterAimVectorMode))
    private val randomizedAimVectorMode by mode("RandomizedAimVector", arrayOf(NoRandomizedAimVectorMode, NormalRandomizedAimVectorMode, SecureRandomRandomizedAimVectorMode))
    private val randomizedRotationMode by mode("RandomizedRotation", arrayOf(NoRandomizedRotationMode, MullerBoxRandomized, NoiseRandomizedRotationMode))

    /* Rotation Speed */
    private val yawSpeed by floatRange("YawSpeed", 40f, 40f, 0f, 180f)
    private val pitchSpeed by floatRange("PitchSpeed", 40f, 40f, 0f, 180f)

    private val rotationSpeedMode by mode("RotationSpeedMode", arrayOf(
        LinearRotationSpeedMode(),
        HumanizedRotationSpeedMode()
    ))

    private val resetTicks by int("ResetTicks", 0, 0, 20)
    private val movementCorrection by enum("MovementCorrection", MovementCorrection.Type.FULL)

    var currentTarget: EntityLivingBase? = null
    var renderBlocking = false
    private val prevEntities = mutableListOf<EntityLivingBase>()
    private val switchTimer = MSTimer()
    private val attackTimer = MSTimer()
    private var delay = 0L
    private var clicks = 0

    override fun onEnable() {
        currentTarget = null

        mc.thePlayer ?: return
    }

    override fun onDisable() {
        mc.thePlayer ?: return
        mc.theWorld ?: return

        runReleaseBlocking()

        renderBlocking = false
        currentTarget = null
    }

    @EventHandler
    fun onReach(event: ReachEvent) {
        val currentTarget = this.currentTarget
        val range = if (currentTarget != null && !mc.thePlayer.canEntityBeSeen(currentTarget)) throughWallsRange else attackRange

        event.range = range
        event.blockReachDistance = mc.playerController.blockReachDistance.coerceAtLeast(range)
    }

    @EventHandler
    fun onPost(event: PostMotionEvent){
        if(grimexploit){
            sendPacket(
                C06PacketPlayerPosLook(mc.thePlayer)
            )
        }
    }

    @EventHandler
    fun onGameLoop(event: GameLoopEvent) {
        mc.theWorld ?: return

        val canSeenEntities = mutableListOf<EntityLivingBase>()
        val cantSeenEntities = mutableListOf<EntityLivingBase>()

        for (entity in mc.theWorld.loadedEntityList) {
            val distance = mc.thePlayer.getDistanceToEntityBox(entity)

            if (entity is EntityLivingBase && EntityUtils.isSelected(entity, true) && distance <= discoveredRange) {
                if (mc.thePlayer.canEntityBeSeen(entity))
                    canSeenEntities.add(entity)
                else if (distance <= throughWallsRange)
                    cantSeenEntities.add(entity)
            }
        }

        when (priority.lowercase()) {
            "health" -> {
                canSeenEntities.sortBy { it.effectiveHealth }
                cantSeenEntities.sortBy { it.effectiveHealth }
            }
            "distance" -> {
                canSeenEntities.sortBy { RotationUtils.getDistanceToEntityBox(it) }
                cantSeenEntities.sortBy { it.effectiveHealth }
            }
        }

        val entities = canSeenEntities + cantSeenEntities
        if (entities.isEmpty() || currentTarget != null && !entities.contains(currentTarget)) {
            currentTarget = null
            return
        }

        when (targetMode.lowercase()) {
            "single" -> currentTarget = entities.firstOrNull()
            "switch" -> {
                if (!switchTimer.hasTimePassed(switchDelayValue)) {
                    if (currentTarget !in entities)
                        currentTarget = entities.firstOrNull()

                    return
                }

                val filteredEntites = entities.filter { it !in prevEntities }

                if (filteredEntites.isNotEmpty()) {
                    val entity = filteredEntites.first()
                    currentTarget = entity
                    prevEntities.add(entity)
                    switchTimer.reset()
                    return
                }

                currentTarget = null
                prevEntities.clear()
            }
        }
    }

    @EventHandler
    fun onRender(event: Render3DEvent) {
        currentTarget ?: return

        if (cpsAlgorithm.cps.maximum == 0)
            return

        if (attackTimer.hasTimePassed(delay)) {
            ++clicks
            delay = getClickDelay()
            attackTimer.reset()
        }
    }

    @EventHandler
    fun onRotation(event: PlayerRotationEvent) {
        mc.thePlayer ?: return
        mc.theWorld ?: return

        val currentTarget = this.currentTarget ?: return

        mc.entityRenderer.getMouseOver(1.0F)
        mc.objectMouseOver?.let {
            if (dontCalculateNewRotationIfPlayerFacingOnTarget && it.entityHit == currentTarget){
                RotationComponent.ticks++
                return
            }
        }

        val aimVectorRotation = aimVectorMode.getVectorRotation(currentTarget)
        val randomizedVectorRotation = randomizedAimVectorMode.randomize(aimVectorRotation)
        val vectorRotation = randomizedRotationMode.randomize(randomizedVectorRotation)

        if(grimexploit){
            sendPacket(C06PacketPlayerPosLook(mc.thePlayer))
        }

        RotationComponent.setRotation(
            vectorRotation.rotation,
            yawSpeed = RandomUtils.nextFloat(yawSpeed.minimum, yawSpeed.maximum),
            pitchSpeed = RandomUtils.nextFloat(pitchSpeed.minimum, pitchSpeed.maximum),
            speedMode = rotationSpeedMode,
            fixType = movementCorrection,
            ticks = resetTicks
        )
    }

    @EventHandler
    fun onMouse(event: MouseInputEvent) {
        mc.thePlayer ?: return

        if (autoBlock && releaseBlocking && releaseBlockingTiming.equals("pre", true))
            runReleaseBlocking()

        currentTarget?.let {
            if (autoBlock && autoBlockTiming.equals("pre", true)) {
                runAutoBlock()
            }

            while (clicks > 0) {
                when (clickMode.lowercase()) {
                    "mouse" -> if (mc.thePlayer.getDistanceToEntityBox(it) <= clickRange) MouseHandler.clickMouse()
                    "packet" -> if (canPlayerAttackOnTarget(it)) AttackOrder.sendFixedAttack(mc.thePlayer, it, viaFixes)
                }

                if(grimexploit) sendPacket(C06PacketPlayerPosLook(mc.thePlayer))

                clicks--
            }

            if (autoBlock && autoBlockTiming.equals("post", true))
                runAutoBlock()
        }

        if (autoBlock && releaseBlocking && releaseBlockingTiming.equals("post", true))
            runReleaseBlocking()
    }

    private fun canPlayerAttackOnTarget(target: EntityLivingBase): Boolean {
        if (!mc.thePlayer.canEntityBeSeen(target))
            return true

        if (mc.currentScreen is GuiInventory && checkInventory)
            return false

        return when (raycastMode.lowercase()) {
            "legit" -> mc.objectMouseOver.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mc.objectMouseOver.entityHit == target
            "throughwalls" -> {
                val eyes = mc.thePlayer.eyes
                val range = attackRange
                var rotationVec = mc.thePlayer.getVectorForRotation(mc.thePlayer.rotationPitch, mc.thePlayer.rotationYaw)

                rotationVec = Vec3(rotationVec.xCoord * range, rotationVec.yCoord * range, rotationVec.zCoord * range)
                rotationVec = Vec3(rotationVec.xCoord + eyes.xCoord, rotationVec.yCoord + eyes.yCoord, rotationVec.zCoord + eyes.zCoord)

                target.hitBox.isVecInside(eyes) || target.hitBox.calculateIntercept(eyes, rotationVec) != null
            }
            else -> {
                mc.thePlayer.getDistanceToEntityBox(target) <= attackRange
            }
        }
    }

    private fun runAutoBlock(render: Boolean = true) {
        if (!autoBlock || mc.thePlayer.getDistanceToEntityBox(currentTarget) > autoBlockRange)
            return

        val heldItem = mc.thePlayer.heldItem ?: return
        val item = heldItem.item
        if (item !is ItemSword)
            return

        when (autoBlockMode.lowercase()) {
            "vanilla" -> {
                mc.netHandler.addToSendQueue(C08PacketPlayerBlockPlacement(heldItem))
            }
            "ncp" -> mc.thePlayer.setItemInUse(heldItem, 32767)
            "aac", "interact", "intave", "grim" -> {
                val entityHit = mc.objectMouseOver?.entityHit ?: return
                mc.playerController.interactWithEntitySendPacket(mc.thePlayer, entityHit)
                mc.netHandler.addToSendQueue(C08PacketPlayerBlockPlacement(heldItem))
            }
            "rightclick" -> {
                MouseHandler.rightClickMouse()
            }
        }

        renderBlocking = render
    }

    private fun runReleaseBlocking() {
        val currentItem = mc.thePlayer.heldItem?.item

        if (currentItem is ItemSword && renderBlocking) {
            sendPacket(
                C07PacketPlayerDigging(
                    C07PacketPlayerDigging.Action.RELEASE_USE_ITEM,
                    BlockPos.ORIGIN,
                    EnumFacing.DOWN
                )
            )
            renderBlocking = false
        }
    }

    private fun getClickDelay(): Long = when (combatMode.lowercase()) {
        "1.9+" -> (1000 / mc.thePlayer.currentItemAttackSpeed).roundToLong()
        else -> cpsAlgorithm.calculate()
    }

    val range: Float
        get() = if (clickMode == "Mouse") clickRange else attackRange

    override val tag: String
        get() = targetMode
}
