package net.bloom.bloomclient.features.module.modules.combat

import net.bloom.bloomclient.event.AttackEvent
import net.bloom.bloomclient.event.PreUpdateEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.player.MovementUtils
import net.lenni0451.lambdaevents.EventHandler

object ModuleHitSelect : Module(name = "HitSelect", description = "Choose the best time to hit.", category = ModuleCategory.COMBAT) {
    private val modes = list("Modes", "Active", arrayOf("Pause", "Active"))
    private val preferences = list("Preferences", "MoveSpeed", arrayOf("MoveSpeed", "KBReduction", "CriticalHits"))
    private val chance by int("Chance", 80, 0, 100)
    private val delay by int("Delay", 420, 300, 500)
    private var attackTime = -1L
    private var currentShouldAttack = false

    fun canAttack(): Boolean {
        if (!ModuleHitSelect.state || modes.equals("Active"))
            return true

        return currentShouldAttack
    }

    @EventHandler(priority = -5)
    fun onAttack(event: AttackEvent) {
        if (modes.equals("Active") && !currentShouldAttack) {
            event.isCancelled = true
            return
        }

        if (canAttack())
            attackTime = System.currentTimeMillis()
    }

    @EventHandler(priority = 5)
    fun onPreUpdate(event: PreUpdateEvent) {
        currentShouldAttack = false

        if (Math.random() * 100 > chance) {
            currentShouldAttack = true
        } else {
            when (preferences.get().lowercase()) {
                "kbreduction" -> currentShouldAttack = mc.thePlayer.hurtTime > 0 && !mc.thePlayer.onGround && MovementUtils.isMoving
                "criticalhits" -> currentShouldAttack = !mc.thePlayer.onGround && mc.thePlayer.motionY < 0
            }

            if (!currentShouldAttack)
                currentShouldAttack = System.currentTimeMillis() - attackTime >= delay
        }
    }
}