package net.bloom.bloomclient.features.module.modules.combat

import net.bloom.bloomclient.event.AttackEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.combat.criticals.JumpCriticals
import net.bloom.bloomclient.utils.struct.MSTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.entity.EntityLivingBase

object ModuleCriticals : Module(
    name = "Criticals",
    description = "",
    category = ModuleCategory.COMBAT
) {
    val mode by mode("Mode", arrayOf(JumpCriticals))
    val delay by int("Delay", 0, 0, 500)
    private val hurtTime by int("HurtTime", 10, 0, 10)
    private val msTimer = MSTimer()

    @EventHandler
    fun onAttack(event: AttackEvent){
        if (event.target is EntityLivingBase) {
            val thePlayer = mc.thePlayer ?: return
            val entity = event.target

            if (!thePlayer.onGround ||
                thePlayer.isOnLadder ||
                thePlayer.isInWeb ||
                thePlayer.ridingEntity != null ||
                entity.hurtTime > hurtTime ||
                !msTimer.hasTimePassed(delay)
            ) {
                return
            }

            mode.handleCritical(entity)

            msTimer.reset()
        }
    }
}