package net.bloom.bloomclient.features.module.modules.combat

import net.bloom.bloomclient.event.GameLoopEvent
import net.bloom.bloomclient.event.ReceivedPacketEvent
import net.bloom.bloomclient.event.Render3DEvent
import net.bloom.bloomclient.event.SentPacketEvent
import net.bloom.bloomclient.features.component.components.player.PacketComponent.processPacket
import net.bloom.bloomclient.features.component.components.player.PacketComponent.sendPackets
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.world.ModuleScaffold
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.network.TimedPacket
import net.bloom.bloomclient.utils.render.RenderUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.multiplayer.WorldClient
import net.minecraft.entity.EntityLivingBase
import net.minecraft.network.Packet
import net.minecraft.network.play.server.*
import net.minecraft.util.Vec3
import java.awt.Color

object ModuleBackTrack : Module(name = "BackTrack", description = "Let you attack in their previous position", category = ModuleCategory.COMBAT) {
    // Settings
    private val delay = intRange("Delay", 150, 200, 0, 1000)
    private val blockClientSide = bool("ClientSide", true)
    private val releasePacketOnHit = bool("ReleasePacketOnHit", true) { blockClientSide.get() }
    private val onlyBacktrackIfOutRange = bool("OnlyBacktrackIfOutRange", true)
    private val esp = bool("ESP", true)

    val color = Color(72, 125, 227)
    private var lastRealX = 0.0
    private var lastRealY = 0.0
    private var lastRealZ = 0.0
    private var lastWorld: WorldClient? = null
    private var entity: EntityLivingBase? = null
    private var dynamicDelay = 0
    private var lastDelayAdjustment = 0L
    private val incomingPackets = mutableListOf<TimedPacket>()
    private val outgoingPackets = mutableListOf<TimedPacket>()

    override fun onEnable() {
        incomingPackets.clear()
        outgoingPackets.clear()
    }

    @EventHandler(priority = Int.MIN_VALUE)
    fun onSendPacket(event: SentPacketEvent) {
        if (mc.thePlayer == null || mc.theWorld == null || mc.netHandler.networkManager.netHandler == null) {
            outgoingPackets.clear()
            return
        }

        if(event.packet.reuseable)
            return

        if (ModuleScaffold.state) {
            outgoingPackets.clear()
            return
        }

        entity = null
        if (ModuleKillAura.state)
            entity = ModuleKillAura.currentTarget

        if (mc.theWorld != null && lastWorld != mc.theWorld) {
            resetOutgoingPackets()
            lastWorld = mc.theWorld
        } else {
            if (entity != null && (!onlyBacktrackIfOutRange.get() || mc.thePlayer.getDistanceToEntity(entity) >= 3.0f)) {
                addOutgoingPackets(event.packet, event)
            } else {
                resetOutgoingPackets()
            }
        }
    }

    @EventHandler(priority = Int.MAX_VALUE)
    fun onReceivePacket(event: ReceivedPacketEvent) {
        if (mc.thePlayer == null || mc.theWorld == null || mc.netHandler.networkManager.netHandler == null) {
            incomingPackets.clear()
            return
        }

        if(event.packet.reuseable)
            return

        if (ModuleScaffold.state) {
            incomingPackets.clear()
            return
        }

        when (val packet = event.packet) {
            is S14PacketEntity -> {
                val entity = mc.theWorld.getEntityByID(packet.entityId)
                if (entity is EntityLivingBase) {
                    entity.realPosX += packet.x.toDouble()
                    entity.realPosY += packet.y.toDouble()
                    entity.realPosZ += packet.z.toDouble()
                }
            }
            is S18PacketEntityTeleport -> {
                val entity = mc.theWorld.getEntityByID(packet.entityId)
                if (entity is EntityLivingBase) {
                    entity.realPosX = packet.x.toDouble()
                    entity.realPosY = packet.y.toDouble()
                    entity.realPosZ = packet.z.toDouble()
                }
            }
        }

        entity = null
        if (ModuleKillAura.state)
            entity = ModuleKillAura.currentTarget

        if (mc.theWorld != null && lastWorld != mc.theWorld) {
            resetIncomingPackets()
            lastWorld = mc.theWorld
        } else {
            if (entity != null && (!onlyBacktrackIfOutRange.get() || mc.thePlayer.getDistanceToEntity(entity) >= 3.0f)) {
                addIncomingPackets(event.packet, event)
            } else {
                resetIncomingPackets()
            }
        }
    }

    @EventHandler
    fun onGameLoop(event: GameLoopEvent) {
        mc.thePlayer ?: return
        mc.theWorld ?: return

        val entity = this.entity ?: return

        if (entity.entityBoundingBox == null || entity.realPosX == 0.0 || entity.realPosY == 0.0 || entity.realPosZ == 0.0 || entity.width == 0.0f || entity.height == 0.0f || entity.posX == 0.0 || entity.posY == 0.0 || entity.posZ == 0.0)
            return

        if (System.currentTimeMillis() - lastDelayAdjustment > 1000) {
            dynamicDelay = RandomUtils.nextInt(delay.value.minimum, delay.value.maximum + 1)
            lastDelayAdjustment = System.currentTimeMillis()
        }

        val realX = entity.realPosX / 32.0
        val realY = entity.realPosY / 32.0
        val realZ = entity.realPosZ / 32.0

        val entityDistance = mc.thePlayer.getDistance(entity.posX, entity.posY, entity.posZ)
        val realDistance = mc.thePlayer.getDistance(realX, realY, realZ)
        val lastRealDistance = mc.thePlayer.getDistance(lastRealX, lastRealY, lastRealZ)

        if (!onlyBacktrackIfOutRange.get()) {
            if (mc.thePlayer.getDistanceToEntity(entity) > 3.0f && entityDistance >= realDistance) {
                resetIncomingPackets()
                resetOutgoingPackets()
            }
        } else if (entityDistance >= realDistance || realDistance < lastRealDistance) {
            resetIncomingPackets()
            resetOutgoingPackets()
        }

        if (blockClientSide.get() && releasePacketOnHit.get() && entity.hurtTime <= 1) {
            resetIncomingPackets()
            resetOutgoingPackets()
        }

        if (realDistance > ModuleKillAura.discoveredRange) {
            resetIncomingPackets()
            resetOutgoingPackets()
        }

        latencyResetIncomingPackets()
        latencyResetOutgoingPackets()

        lastRealX = realX
        lastRealY = realY
        lastRealZ = realZ
    }

    @EventHandler
    fun onRender3D(event: Render3DEvent) {
        mc.thePlayer ?: return
        mc.theWorld ?: return

        val entity = this.entity ?: return

        if (entity.entityBoundingBox == null || mc.thePlayer == null || mc.theWorld == null || entity.realPosX == 0.0 || entity.realPosY == 0.0 || entity.realPosZ == 0.0 || entity.width == 0.0f || entity.height == 0.0f || entity.posX == 0.0 || entity.posY == 0.0 || entity.posZ == 0.0 || !esp.get())
            return

        var render = true
        val realX = entity.realPosX / 32.0
        val realY = entity.realPosY / 32.0
        val realZ = entity.realPosZ / 32.0

        val entityDistance = mc.thePlayer.getDistance(entity.posX, entity.posY, entity.posZ)
        val realDistance = mc.thePlayer.getDistance(realX, realY, realZ)
        val lastRealDistance = mc.thePlayer.getDistance(lastRealX, lastRealY, lastRealZ)

        if (!onlyBacktrackIfOutRange.get()) {
            if (mc.thePlayer.getDistanceToEntity(entity) > 3.0f && entityDistance >= realDistance)
                render = false

        } else if (mc.thePlayer.getDistance(entity.posX, entity.posY, entity.posZ) >= realDistance || realDistance < lastRealDistance)
            render = false

        if (releasePacketOnHit.get() && entity.hurtTime <= 1)
            render = false

        if (realDistance > ModuleKillAura.discoveredRange) {
            render = false
        }

        if (entity != mc.thePlayer && !entity.isInvisible && render) {
            if (entity.width == 0.0f || entity.height == 0.0f)
                return

            RenderUtils.drawPosByVec(Vec3(realX, realY, realZ), color)
        }
    }

    private fun latencyResetIncomingPackets(){
        synchronized(incomingPackets) {
            for (timedPacket in incomingPackets.toList()) {
                if (System.currentTimeMillis() - lastDelayAdjustment > 1000) {
                    dynamicDelay = RandomUtils.nextInt(delay.value.minimum, delay.value.maximum + 1)
                    lastDelayAdjustment = System.currentTimeMillis()
                }

                if (System.currentTimeMillis() - timedPacket.time > dynamicDelay) {
                    processPacket(timedPacket.packet)
                    incomingPackets.remove(timedPacket)
                    debug("Latency incoming reset")
                }
            }
        }
    }

    private fun resetIncomingPackets() {
        synchronized(incomingPackets) {
            while (incomingPackets.isNotEmpty()) {
                val timedPacket = incomingPackets.removeFirst()
                processPacket(timedPacket.packet)
            }
        }
    }

    private fun addIncomingPackets(packet: Packet<*>, event: ReceivedPacketEvent) {
        synchronized(incomingPackets) {
            incomingPackets.add(TimedPacket(packet))
            event.isCancelled = true
            event.packet.reuseable = true
        }
    }

    private fun latencyResetOutgoingPackets(){
        synchronized(outgoingPackets) {
            for (timedPacket in outgoingPackets.toList()) {
                if (System.currentTimeMillis() - lastDelayAdjustment > 1000) {
                    dynamicDelay = RandomUtils.nextInt(delay.value.minimum, delay.value.maximum + 1)
                    lastDelayAdjustment = System.currentTimeMillis()
                }

                if (System.currentTimeMillis() - timedPacket.time > dynamicDelay) {
                    sendPackets(timedPacket.packet)
                    outgoingPackets.remove(timedPacket)
                    debug("Latency outgoing reset")
                }
            }
        }
    }

    private fun resetOutgoingPackets() {
        synchronized(outgoingPackets) {
            while (outgoingPackets.isNotEmpty()) {
                val timedPacket = outgoingPackets.removeFirst()
                sendPackets(timedPacket.packet)
            }
        }
    }

    private fun addOutgoingPackets(packet: Packet<*>, event: SentPacketEvent) {
        synchronized(outgoingPackets) {
            outgoingPackets.add(TimedPacket(packet))
            event.isCancelled = true
            event.packet.reuseable = true
        }
    }
}
