package net.bloom.bloomclient.features.module.modules.combat

import net.bloom.bloomclient.event.GameLoopEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.combat.autoclicker.DragClickAutoClicker
import net.bloom.bloomclient.features.module.modules.combat.autoclicker.NormalAutoClicker
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding

object ModuleAutoClicker: Module(name = "AutoClicker", description = "Constantly clicks when holding down a mouse button.", category = ModuleCategory.COMBAT) {
    private val leftClick = bool("LeftClick", true)
    private val rightClick = bool("RightClick", true)

    private val modes = mode("Mode", arrayOf(
        NormalAutoClicker,
        DragClickAutoClicker
    ))

    private val breakBlocks = bool("BreakBlocks", true)

    val shouldLeftClick: Boolean
        get() = KeyBinding.keyBindAttack.isKeyDown && leftClick.get() && (!breakBlocks.get() || mc.playerController.curBlockDamageMP == 0f)

    private val shouldRightClick: Boolean
        get() = KeyBinding.keyBindUseItem.isKeyDown && !mc.thePlayer.isUsingItem && rightClick.get()

    @EventHandler
    fun onGameLoop(event: GameLoopEvent) {
        val mode = modes.get()

        if (shouldLeftClick)
            mode.handleLeftClick()

        if (shouldRightClick)
            mode.handleRightClick()
    }

    fun click(rightClick: Boolean) {
        val keyCode = if (rightClick) KeyBinding.keyBindUseItem.keyCode else KeyBinding.keyBindAttack.keyCode
        KeyBinding.setKeyBindState(keyCode, true)
        KeyBinding.onTick(keyCode)
    }

}