package net.bloom.bloomclient.features.module.modules.combat

import de.florianmichael.viamcp.fixes.AttackOrder
import net.bloom.bloomclient.event.MouseInputEvent
import net.bloom.bloomclient.event.PlayerRotationEvent
import net.bloom.bloomclient.features.component.components.player.MovementCorrection
import net.bloom.bloomclient.features.component.components.player.RotationComponent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.shared.rotationspeed.HumanizedRotationSpeedMode
import net.bloom.bloomclient.features.shared.rotationspeed.LinearRotationSpeedMode
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.extension.minus
import net.bloom.bloomclient.utils.player.RotationUtils.toRotation
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.entity.projectile.EntityFireball
import net.minecraft.util.MathHelper.getNearestPointBB
import net.minecraft.util.MovingObjectPosition

object ModuleAntiFireball : Module(name = "AntiFireball", description = "Make fireballs roll back", category = ModuleCategory.COMBAT) {
    private val range = float("Range", 8f, 0f, 8f)
    private val rotationSpeedMode by mode("RotationSpeedMode", arrayOf(
        LinearRotationSpeedMode(),
        HumanizedRotationSpeedMode()
    ))
    private val movementCorrection by enum("MovementCorrection", MovementCorrection.Type.FULL)
    private val yawSpeed by floatRange("YawSpeed", 0f, 180f, 0f, 180f)
    private val pitchSpeed by floatRange("PitchSpeed", 0f, 180f, 0f, 180f)
    private val resetTicks by int("ResetTicks", 0, 0, 20)

    @EventHandler
    private fun onRotation(event: PlayerRotationEvent) {
        val player = mc.thePlayer ?: return

        for (entity in mc.theWorld.loadedEntityList.filterIsInstance<EntityFireball>().sortedBy { player.getDistanceToBox(it.hitBox) }) {
            val nearestPoint = getNearestPointBB(player.eyes, entity.hitBox)
            val entityPrediction = entity.positionVector - entity.prevPos
            val normalDistance = player.getDistanceToBox(entity.hitBox)
            val predictedDistance = player.getDistanceToBox(entity.hitBox.offset(entityPrediction))

            // Skip if the predicted distance is further than (or the same as) the normal distance
            // or the predicted distance is out of reach
            if (predictedDistance >= normalDistance || predictedDistance > range.get())
                continue

            RotationComponent.setRotation(
                toRotation(nearestPoint),
                yawSpeed = RandomUtils.nextFloat(yawSpeed.minimum, yawSpeed.maximum),
                pitchSpeed = RandomUtils.nextFloat(pitchSpeed.minimum, pitchSpeed.maximum),
                speedMode = rotationSpeedMode,
                fixType = movementCorrection,
                ticks = resetTicks
            )

            break
        }
    }

    @EventHandler
    fun onMouse(event: MouseInputEvent){
        mc.objectMouseOver ?: return
        if (mc.objectMouseOver.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (mc.objectMouseOver.entityHit is EntityFireball) {
                AttackOrder.sendFixedAttack(mc.thePlayer, mc.objectMouseOver.entityHit, true)
            }
        }
    }
}