package net.bloom.bloomclient.features.module.modules.advanced

import net.bloom.bloomclient.event.AttackEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.io.FileUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.entity.EntityLivingBase
import java.io.File

object ClicksRecordingModule : Module(
    name = "ClicksRecording",
    description = "Records clicks for machine learning purposes.",
    category = ModuleCategory.ADVANCED
) {
    private var lastClick: Long = -1
    private val logFile = File("logs/clicks.csv")

    init {
        if (!logFile.exists()) {
            logFile.parentFile?.mkdirs()
            logFile.createNewFile()
            FileUtils.writeLine(logFile, "timestamp,interval_ms,target,hurtTime")
        }
    }

    override fun onEnable() {
        lastClick = -1
        logFile.parentFile?.mkdirs()
        if (logFile.exists()) logFile.delete()
        logFile.createNewFile()
        FileUtils.writeLine(logFile, "timestamp,interval_ms,target,hurtTime")
        debug("[ClickLogger] Enabled → writing to ${logFile.absolutePath}")
        debug("Play legit to ensure a high-quality dataset for ML training.")
    }

    override fun onDisable() {
        debug("Click recording stopped. Dataset ready.")
    }

    @EventHandler
    fun onAttack(event: AttackEvent) {
        val now = System.currentTimeMillis()
        val interval = if (lastClick != -1L) now - lastClick else 0
        lastClick = now

        val target = event.target
        val name = target?.name ?: "null"
        val hurtTime = if (target is EntityLivingBase) target.hurtTime else -1

        debug("[ClickLogger] interval=${interval}ms, target=$name, hurtTime=$hurtTime")
        FileUtils.writeLine(logFile, "$now,$interval,$name,$hurtTime")
    }
}
