package net.bloom.bloomclient.features.component.components.viaversion

import com.viaversion.viarewind.protocol.v1_9to1_8.Protocol1_9To1_8
import com.viaversion.viaversion.api.minecraft.BlockPosition
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion
import com.viaversion.viaversion.api.type.Types
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ServerboundPackets1_9
import de.florianmichael.vialoadingbase.ViaLoadingBase
import net.bloom.bloomclient.event.SentPacketEvent
import net.bloom.bloomclient.features.component.Component
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.network.play.client.C1APacketSwapHand

object ViaPacketHandlerComponent: Component() {

    @EventHandler
    fun onSentPacket(event: SentPacketEvent) {
        val packet = event.packet

        when (packet) {
            is C1APacketSwapHand -> {
                event.isCancelled = true

                if (ViaLoadingBase.getInstance().targetVersion >= ProtocolVersion.v1_9) {
                    val swapItemPacket = PacketWrapper.create(ServerboundPackets1_9.PLAYER_ACTION, ViaLoadingBase.getUserConnection())
                    swapItemPacket.write(Types.VAR_INT, 6)
                    swapItemPacket.write(Types.BLOCK_POSITION1_8, BlockPosition(0, 0, 0))
                    swapItemPacket.write(Types.BYTE, 0.toByte())

                    try {
                        swapItemPacket.sendToServer(Protocol1_9To1_8::class.java)
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            }
        }

    }

}