package net.bloom.bloomclient.features.component.components.viaversion

import com.viaversion.viabackwards.protocol.v1_19to1_18_2.Protocol1_19To1_18_2
import com.viaversion.viarewind.protocol.v1_9to1_8.Protocol1_9To1_8
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion
import com.viaversion.viaversion.api.type.Types
import com.viaversion.viaversion.protocols.v1_18_2to1_19.packet.ServerboundPackets1_19
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ServerboundPackets1_9
import de.florianmichael.vialoadingbase.ViaLoadingBase
import net.bloom.bloomclient.event.SentPacketEvent
import net.bloom.bloomclient.features.component.Component
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement


object ViaFixesComponent: Component() {
    private val targetVersion: ProtocolVersion
        get() = ViaLoadingBase.getInstance().targetVersion

    @EventHandler(priority = -999)
    fun onSentPacket(event: SentPacketEvent) {
        if (mc.isSingleplayer)
            return

        val packet = event.packet

        if (packet is C08PacketPlayerBlockPlacement && packet.placedBlockDirection == 255) {
            if (targetVersion >= ProtocolVersion.v1_19) {
                event.isCancelled = true

                val useItemPacket = PacketWrapper.create(ServerboundPackets1_19.USE_ITEM, ViaLoadingBase.getUserConnection())
                useItemPacket.write(Types.VAR_INT, 1)
                useItemPacket.write(Types.VAR_INT, mc.playerController.nextTickPlayerController)
                useItemPacket.sendToServer(Protocol1_19To1_18_2::class.java)
            } else if (targetVersion >= ProtocolVersion.v1_9) {
                event.isCancelled = true

                val useItemPacket = PacketWrapper.create(ServerboundPackets1_9.USE_ITEM, ViaLoadingBase.getUserConnection())
                useItemPacket.write(Types.VAR_INT, 1)
                useItemPacket.sendToServer(Protocol1_9To1_8::class.java)
            }
        }
    }
}