package net.bloom.bloomclient.features.component.components.player

import net.bloom.bloomclient.event.PlayerRotationEvent
import net.bloom.bloomclient.event.UpdateEvent
import net.bloom.bloomclient.features.component.Component
import net.bloom.bloomclient.features.shared.rotationspeed.LinearRotationSpeedMode
import net.bloom.bloomclient.features.shared.rotationspeed.RotationSpeedMode
import net.bloom.bloomclient.utils.extension.withGCD
import net.bloom.bloomclient.utils.player.RotationUtils.getFixedAngleDelta
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.MouseOption
import net.minecraft.util.MathHelper
import net.minecraft.util.Rotation
import net.minecraft.util.Vec3
import kotlin.math.abs
import kotlin.math.pow
import kotlin.math.roundToInt

object RotationComponent: Component() {
    @JvmField var serverPosition = Vec3(0.0, 0.0, 0.0)
    @JvmField var lastServerPosition = serverPosition
    @JvmField var rotIncrement = 0

    @JvmField var tickRotation = Rotation(0f, 0f)
    @JvmField var lastTickRotaton = Rotation(0f, 0f)

    private val defaultSpeedMode = LinearRotationSpeedMode()
    private var yawSpeed = 180f
    private var pitchSpeed = 180f
    private var rotations = Rotation(0f, 0f)
    private var speedMode: RotationSpeedMode = defaultSpeedMode
    @JvmField var isActive = false

    var ticks = 2


    /**
     * Set your target rotation
     *
     * This method must be called on Player Rotation Event to work correctly
     */
    @JvmOverloads
    fun setRotation(
        rotation: Rotation,
        yawSpeed: Float = 180f,
        pitchSpeed: Float = 180f,
        speedMode: RotationSpeedMode = defaultSpeedMode,
        fixType: MovementCorrection.Type = MovementCorrection.Type.FULL,
        ticks: Int = 2
    ) {
        if (rotation.isInvalidRotation)
            return

        MovementCorrection.type = fixType
        this.yawSpeed = yawSpeed
        this.pitchSpeed = pitchSpeed
        this.rotations = rotation
        this.ticks = ticks
        this.speedMode = speedMode
        isActive = true
    }

    @EventHandler(priority = -5)
    fun onPlayerRotation(event: PlayerRotationEvent) {
        mc.thePlayer ?: return

        if(isActive){
            val (playerYaw, playerPitch) = mc.thePlayer.rotation

            speedMode.calculate(rotations, yawSpeed, pitchSpeed).let {
                val deltaYaw = MathHelper.wrapAngleTo180(it.yaw - playerYaw)
                val deltaPitch = (it.pitch - playerPitch) * -1.0F

                event.modifiedYaw = (deltaYaw / getFixedAngleDelta()).roundToInt()
                event.modifiedPitch = (deltaPitch / getFixedAngleDelta()).roundToInt()
                event.isActive = isActive

                if (abs((it.yaw - mc.thePlayer.playerYaw) % 360) < 1 && abs((it.pitch - mc.thePlayer.playerPitch)) < 1) {
                    isActive = false
                }
            }
        }

        when {
            ticks == 0 -> rotations = mc.thePlayer.playerRotation
            ticks > 0 -> ticks--
        }
    }
}
