package net.bloom.bloomclient.features.component.components.player

import net.bloom.bloomclient.event.JumpEvent
import net.bloom.bloomclient.event.MoveInputEvent
import net.bloom.bloomclient.event.StrafeEvent
import net.bloom.bloomclient.features.component.Component
import net.bloom.bloomclient.utils.extension.toRadians
import net.bloom.bloomclient.utils.player.MovementUtils
import net.lenni0451.lambdaevents.EventHandler
import kotlin.math.*

object MovementCorrection: Component() {
    @JvmField
	var type = Type.NONE

    enum class Type {
	    NONE, NORMAL, FULL, SILENT
	}

	@EventHandler(priority = Int.MAX_VALUE)
	fun onStrafe(event: StrafeEvent) {
		mc.thePlayer ?: return

		if (mc.thePlayer.playerRotation != mc.thePlayer.rotation && type == Type.NONE)
			event.yaw = mc.thePlayer.playerYaw
	}

	@EventHandler(priority = Int.MAX_VALUE)
	fun onJump(event: JumpEvent) {
		mc.thePlayer ?: return

		if (mc.thePlayer.playerRotation != mc.thePlayer.rotation && type == Type.NONE)
			event.yaw = mc.thePlayer.playerYaw
	}

	@EventHandler(priority = Int.MAX_VALUE)
	fun onMoveInput(event: MoveInputEvent) {
		mc.thePlayer ?: return

		val rotation = mc.thePlayer.rotation
		val predictedMovement = MovementUtils.handleSilentMove(event.strafe, event.forward, rotation)
		val diffForward = event.lastForward - predictedMovement.forward
		val diffStrafe = event.lastStrafe - predictedMovement.strafe

		if (diffForward >= 2.0f || diffForward <= -2.0f)
			predictedMovement.forward = 0.0f

		if (diffStrafe >= 2.0f || diffStrafe <= -2.0f)
			predictedMovement.strafe = 0.0f

		val forward = event.forward
		val strafe = event.strafe
		if (type == Type.FULL && mc.thePlayer.playerRotation !== mc.thePlayer.rotation) {
			event.strafe = max(-1f, min(1f, predictedMovement.strafe))
			event.forward = max(-1f, min(1f, predictedMovement.forward))
		}

		if (type == Type.SILENT && mc.thePlayer.playerRotation !== mc.thePlayer.rotation) {
			val angle = (mc.thePlayer.playerYaw - rotation.yaw).toRadians()
			event.forward = round(forward * cos(angle) + strafe * sin(angle))
			event.strafe = round(strafe * cos(angle) - forward * sin(angle))
		}
	}
}