package net.bloom.bloomclient.features.component.components.player

import net.bloom.bloomclient.event.TickEvent
import net.bloom.bloomclient.features.component.Component
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.entity.Entity

object EntitySelectionComponent : Component() {

    private val ignoredEntities = mutableListOf<Entity>()
    private val ignoredConditions = mutableListOf<(Entity) -> Boolean>()

    @EventHandler
    fun onTick(event: TickEvent) {
        ignoredEntities.clear()

        if (mc.theWorld == null || mc.thePlayer == null) return

        for (entity in mc.theWorld.loadedEntityList) {
            for (condition in ignoredConditions) {
                if (condition(entity))
                    ignoredEntities.add(entity)
            }
        }
    }

    fun addIgnoreList(ignoreList: (Entity) -> Boolean) {
        ignoredConditions.add(ignoreList)
    }

    fun isIgnored(entity: Entity): Boolean {
        return ignoredEntities.any { it.entityId == entity.entityId }
    }
}