package net.bloom.bloomclient.features.component.components.patcher

import net.bloom.bloomclient.event.Render3DEvent
import net.bloom.bloomclient.features.component.Component
import net.bloom.bloomclient.features.module.modules.other.ModuleZoom
import net.minecraft.client.option.options.devices.MouseOption
import net.bloom.bloomclient.utils.animations.EaseUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.block.material.Material
import net.minecraft.client.renderer.ActiveRenderInfo
import org.lwjgl.input.Mouse


object ZoomComponent: Component() {
    private const val normalModifier = 4f
    private var currentModifier = normalModifier
    private var hasScrolledYet = false
    private var lastMillis = System.currentTimeMillis()
    private var desiredModifier = currentModifier
    private var zoomToggled = false
    private var isBeingHeld = false
    private var oldSensitivity = 0f
    private var partialTicks = 0f

    @JvmField
    var lastZoomModifier = 0f

    var zoomed = false
    var smoothZoomProgress = 0f

    @JvmStatic
    fun getZoomState(zoomKeyDown: Boolean): Boolean {
        if (zoomKeyDown) {
            if (isBeingHeld)
                return zoomToggled
            isBeingHeld = true
            zoomToggled = !zoomToggled
        } else {
            isBeingHeld = false
        }

        return zoomToggled
    }

    fun getScrollZoomModifier(): Float {
        if (!ModuleZoom.state || !ModuleZoom.scrollToZoom.get())
            return normalModifier

        val currentTime = System.currentTimeMillis()
        val timeSinceLastChange = currentTime - lastMillis

        if (!zoomed)
            lastMillis = currentTime

        val moved = Mouse.getDWheel()
        if (moved > 0) {
            smoothZoomProgress = 0f
            hasScrolledYet = true
            desiredModifier += 0.25f * desiredModifier
        } else if (moved < 0) {
            smoothZoomProgress = 0f
            hasScrolledYet = true
            desiredModifier -= 0.25f * desiredModifier
            mc.renderGlobal.setDisplayListEntitiesDirty()
        }

        if (desiredModifier < 1f)
            desiredModifier = 1f

        if (desiredModifier > 600)
            desiredModifier = 600f

        if (ModuleZoom.smoothZoomAnimationWhenScrolling.get()) {
            if (hasScrolledYet && smoothZoomProgress < 1) {
                mc.renderGlobal.setDisplayListEntitiesDirty()
                smoothZoomProgress += 0.004f * timeSinceLastChange
                smoothZoomProgress = if (smoothZoomProgress > 1) 1f else smoothZoomProgress

                val diff = (desiredModifier - currentModifier) * calculateZoomEasing(smoothZoomProgress)
                currentModifier += diff
                return currentModifier
            }
        } else {
            currentModifier = desiredModifier
        }

        return desiredModifier
    }

    fun getSmoothZoomModifier(): Float {
        val time = System.currentTimeMillis()
        val timeSinceLastChange = time - lastMillis
        lastMillis = time

        if (zoomed) {
            if (hasScrolledYet)
                return 1f

            if (smoothZoomProgress < 1) {
                smoothZoomProgress += 0.005f * timeSinceLastChange
                smoothZoomProgress = if (smoothZoomProgress > 1) 1f else smoothZoomProgress
                return 4f - 3f * calculateZoomEasing(smoothZoomProgress)
            }
        } else {
            if (hasScrolledYet) {
                hasScrolledYet = false
                smoothZoomProgress = 1f
            }

            if (smoothZoomProgress > 0) {
                smoothZoomProgress -= 0.005f * timeSinceLastChange
                smoothZoomProgress = if (smoothZoomProgress < 0) 0f else smoothZoomProgress
                mc.renderGlobal.setDisplayListEntitiesDirty()
                val progress = 1 - smoothZoomProgress
                val diff = if (ModuleZoom.scrollToZoom.get()) 1f / currentModifier else 0.25f
                return diff + (1 - diff) * calculateZoomEasing(progress)
            }
        }
        return 1f
    }

    private fun calculateZoomEasing(x: Float): Float = when (ModuleZoom.smoothZoomAlgorithm.get().lowercase()) {
        "inoutcirc" -> EaseUtils.easeInOutCirc(x)
        "inquint" -> EaseUtils.easeInQuint(x)
        else -> EaseUtils.easeInOutQuad(x)
    }

    fun resetZoomState() {
        hasScrolledYet = false
        currentModifier = normalModifier
        desiredModifier = normalModifier
        smoothZoomProgress = 0f
    }

    fun handleZoomStateChange(newZoomed: Boolean) {
        if (newZoomed && !zoomed) {
            Mouse.getDWheel()
        } else if (!newZoomed && zoomed) {
            resetSensitivity()
        }
        zoomed = newZoomed
    }

    // Sensitivity
    fun reduceSensitivityWhenZoomStarts() {
        oldSensitivity = MouseOption.mouseSensitivity
        MouseOption.mouseSensitivity = oldSensitivity * ModuleZoom.customZoomSensitivity.get()
    }

    fun reduceSensitivityDynamically(modifier: Float) {
        if (!ModuleZoom.dynamicZoomSensitivity.get() || !zoomed)
            return

        var sensitivity = oldSensitivity * ModuleZoom.customZoomSensitivity.get()
        sensitivity *= modifier / lastZoomModifier
        MouseOption.mouseSensitivity = sensitivity
    }

    private fun resetSensitivity() {
        MouseOption.mouseSensitivity = oldSensitivity
    }

    fun getHandFOVModifier(original: Float): Float {
        if (ModuleZoom.state && ModuleZoom.renderHandWhenZoomed.get() && (zoomed || ModuleZoom.smoothZoomAnimation.get() && smoothZoomProgress > 0)) {
            var f = 70f
            val block = ActiveRenderInfo.getBlockAtEntityViewpoint(mc.theWorld, mc.thePlayer, partialTicks)
            if (block.material === Material.water)
                f = f * 60.0f / 70.0f

            return f
        }

        return original
    }

    @EventHandler
    fun onRender3D(event: Render3DEvent) {
        partialTicks = event.partialTicks
    }

}