package net.bloom.bloomclient.features.command.commands

import net.bloom.bloomclient.features.command.Command
import net.bloom.bloomclient.file.FileManager
import java.io.File

class ConfigCommand: Command("config") {
    override fun execute(args: Array<String>) {
        if (args.size > 1) {
            when (args[0].lowercase()) {
                "load" -> if (args.size > 2) {
                    val fileName = args[1].lowercase()
                    val file = File(FileManager.configFolder, "$fileName.json")

                    if (file.exists()) {

                    } else {
                        chat("File $fileName.json is not exists!")
                    }
                } else {
                    chatSyntax("config load <name>")
                }
            }

            return
        }

        chatSyntax("config (load|save) <name>")
    }

    override fun tabComplete(args: Array<String>): List<String> {
        return super.tabComplete(args)
    }
}