package net.bloom.bloomclient.features.command.commands

import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.features.command.Command
import net.bloom.bloomclient.utils.Constants
import org.lwjgl.input.Keyboard

class BindCommand: Command("bind", arrayOf("b")) {

	override fun execute(args: Array<String>) {
		if (args.size <= 1) {
			chatSyntax(arrayOf("<module> <key>", "list", "clear"))
			return
		}

		val moduleName = args[1]
		val module = BloomClient.moduleManager.getModule(moduleName) ?: run {
			chat("Module $moduleName not found.")
			return
		}

		val key = Keyboard.getKeyIndex(args[2].uppercase())
		module.keyBind = key

		chat("Bound module ${module.name} to key ${Keyboard.getKeyName(key)}.")
	}

	override fun tabComplete(args: Array<String>): List<String> {
		return when (args.size) {
			1 -> {
				val subCommand = listOf("list", "clear")
				val moduleNames = BloomClient.moduleManager.modules.map { it.name.lowercase() }.toList()
				(subCommand + moduleNames).filter { it.startsWith(args[0], true) }
			}
			2 -> {
				val subCommand = args.first()
				if (subCommand.equals("list", true) || subCommand.equals("clear", true))
					emptyList()
				else Keyboard.keyNames.filter { it?.startsWith(args[1], true) == true }.sorted()
			}
			else -> emptyList()
		}
	}

}