package net.bloom.bloomclient.features.command

import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.utils.ClientUtils
import net.minecraft.client.MinecraftInstance

abstract class Command(val command: String, val aliases: Array<String> = arrayOf()): MinecraftInstance() {

	protected val prefix: String
		get() = BloomClient.commandManager.prefix

	abstract fun execute(args: Array<String>)

	open fun tabComplete(args: Array<String>): List<String> = emptyList()

	protected fun chat(msg: String) = ClientUtils.displaySystemMessage(msg)

	protected fun chatSyntax(syntax: String) = ClientUtils.displaySystemMessage("§3Syntax: §7$prefix$syntax")

	protected fun chatSyntax(syntaxes: Array<String>) {
		ClientUtils.displaySystemMessage("§3Syntax:")

        for (syntax in syntaxes)
            ClientUtils.displayChatMessage("§8> §7$prefix$command ${syntax.lowercase()}")
	}

	protected fun chatSyntaxError() = ClientUtils.displaySystemMessage("§3Syntax error")
}