package net.bloom.bloomclient.event

import net.lenni0451.lambdaevents.types.CancellableEvent
import net.lenni0451.lambdaevents.types.Event
import net.minecraft.client.gui.ScaledResolution
import net.minecraft.client.multiplayer.WorldClient
import net.minecraft.entity.Entity
import net.minecraft.network.Packet
import net.minecraft.network.play.server.S12PacketEntityVelocity

/**
 * Called when player attacks other entity
 */
class AttackEvent(val target: Entity?, var noEvent: Boolean = false) : CancellableEvent()

class TimerEvent : Event()

class PreSprintEvent : Event()

class PostSprintEvent : Event()

class PreVelocityEvent(val entity: Entity, val packet: S12PacketEntityVelocity) : CancellableEvent()

class PostVelocityEvent(val entity: Entity, val packet: S12PacketEntityVelocity) : Event()

/**
 * Called when player jumps
 */
class JumpEvent(var motion: Float, var yaw: Float, var sprint: Boolean, var sprintFixes: Boolean) : CancellableEvent()

/**
 * Called when user press a key once
 */
class KeyEvent(val key: Int) : Event()

/**
 * Called when player input
 */
class MoveInputEvent(
    var forward: Float,
    var strafe: Float,
    var lastForward: Float,
    var lastStrafe: Float,
    var jump: Boolean,
    var sneak: Boolean,
    var sneakMultiplier: Double
) : Event()

class MoveForwardEvent(var reset: Boolean) : Event()

/**
 * Called before motion
 */
class PreMotionEvent(
    var posX: Double,
    var posY: Double,
    var posZ: Double,
    var yaw: Float,
    var pitch: Float,
    var onGround: Boolean
) : CancellableEvent()

class KnockbackEvent(
    var motion: Double,
    var full: Boolean,
    var power: Int,
    var reduceY: Boolean,
    var sprint: Boolean,
    var flag: Boolean
) : CancellableEvent()

/**
 * Called when rotate
 */
class PlayerRotationEvent(var modifiedYaw: Int, var modifiedPitch: Int, var isActive: Boolean) : Event()

class ReachEvent(var blockReachDistance: Float, var range: Float) : Event()

/**
 * Called when player input action to player
 */
class MouseInputEvent : CancellableEvent()

/**
 * Called after motion
 */
class PostMotionEvent : Event()

/**
 * Called after motion
 */
class LookEvent(var yaw: Float, var pitch: Float) : Event()

/**
 * Called on pre update
 */
class PreUpdateEvent : CancellableEvent()

class PostUpdateEvent : Event()

/**
 * Called in "onLivingUpdate" when the player is using a use item.
 */
class SlowDownEvent(var forward: Float, var strafe: Float, var isUsingItem: Boolean, var sprint: Boolean) : CancellableEvent()

/**
 * Called in "moveFlying"
 */
class StrafeEvent(var yaw: Float, var forward: Float, var strafe: Float, var friction: Float) : CancellableEvent()

class PostStrafeEvent : Event()

/**
 * tick... tack... tick... tack
 */
class TickEvent : Event()

class TickEndEvent : Event()

class GameLoopEvent : Event()

/**
 * Called when minecraft player will be updated
 */
class UpdateEvent : Event()


/**
 * Called when send a packet
 */
class SentPacketEvent(val packet: Packet<*>) : CancellableEvent()

/**
 * Called when receive a packet
 */
class ReceivedPacketEvent(val packet: Packet<*>) : CancellableEvent()

/**
 *  Called when send or receive a packet
 */
class PacketEvent(val packet: Packet<*>, val state: EventState, var reuseable: Boolean) : CancellableEvent()

class NanoVGRenderEvent(val sc: ScaledResolution) : Event()

/**
 * Called when screen is going to be rendered
 */
class Render2DEvent(val partialTicks: Float) : Event()

/**
 * Called when world is going to be rendered
 */
class Render3DEvent(val partialTicks: Float) : Event()

/**
 * Called on world change
 */
class WorldEvent(val world: WorldClient?) : Event()

class RightClickEvent : CancellableEvent()

class MoveEvent(var x: Double, var y: Double, var z: Double) : CancellableEvent()

class FallEvent(var y: Double, var isOnGround: Boolean) : Event()