package net.bloom.bloomclient

import net.bloom.bloomclient.features.command.CommandManager
import net.bloom.bloomclient.features.component.ComponentManager
import net.bloom.bloomclient.features.module.ModuleManager
import net.bloom.bloomclient.file.FileManager
import net.bloom.bloomclient.font.Fonts
import net.bloom.bloomclient.ui.hud.HUD
import net.bloom.bloomclient.utils.ClientUtils
import net.bloom.bloomclient.utils.DictUtils
import net.bloom.bloomclient.utils.render.skiko.SkikoContext
import net.lenni0451.lambdaevents.LambdaManager
import net.lenni0451.lambdaevents.generator.ReflectionGenerator
import net.minecraft.client.language.Language
import org.lwjgl.system.MemoryStack
import java.util.concurrent.Executors
import java.util.concurrent.ScheduledExecutorService


object BloomClient {
	
	const val CLIENT_NAME = "Bloom Client"
	const val CLIENT_VERSION = "0.1"
	const val CLIENT_AUTHOR = "toidicakhia, fmcpe, longathelstan"
	const val CLIENT_FOLDER = "BloomClient"

	lateinit var eventManager: LambdaManager
	lateinit var componentManager: ComponentManager
	lateinit var moduleManager: ModuleManager
	lateinit var commandManager: CommandManager

	var isStarting = false
	val ex: ScheduledExecutorService = Executors.newScheduledThreadPool(4)

	fun startClient() {
		isStarting = true

		Runtime.getRuntime().addShutdownHook(Thread(ex::shutdown))

		try {
			Fonts.downloadFonts()
		} catch (e: Exception){
			ClientUtils.displaySystemMessage(e)
		}

		Fonts.loadFonts()

		eventManager = LambdaManager.threadSafe(ReflectionGenerator())
		componentManager = ComponentManager()
		commandManager = CommandManager()
		moduleManager = ModuleManager()

		commandManager.registerCommands()
		moduleManager.registerModules()
		componentManager.registerComponents()

		SkikoContext.createSurface()

		DictUtils.init()
		FileManager.loadConfig(FileManager.moduleConfig)
		FileManager.loadConfig(FileManager.accountsConfig)
		HUD.setDefault()

		isStarting = false
	}

	fun stopClient() {
		moduleManager.shutdown()
		FileManager.saveAllConfigs()
	}

}