package net.optifine.shaders;

import org.lwjgl.opengl.ARBShaderObjects;

public class ShaderProgramData {
    public final int programIDGL;
    public final int uniform_texture;
    public final int uniform_lightmap;
    public final int uniform_normals;
    public final int uniform_specular;
    public final int uniform_shadow;
    public final int uniform_watershadow;
    public final int uniform_shadowtex0;
    public final int uniform_shadowtex1;
    public final int uniform_depthtex0;
    public final int uniform_depthtex1;
    public final int uniform_shadowcolor;
    public final int uniform_shadowcolor0;
    public final int uniform_shadowcolor1;
    public final int uniform_noisetex;
    public final int uniform_gcolor;
    public final int uniform_gdepth;
    public final int uniform_gnormal;
    public final int uniform_composite;
    public final int uniform_gaux1;
    public final int uniform_gaux2;
    public final int uniform_gaux3;
    public final int uniform_gaux4;
    public final int uniform_colortex0;
    public final int uniform_colortex1;
    public final int uniform_colortex2;
    public final int uniform_colortex3;
    public final int uniform_colortex4;
    public final int uniform_colortex5;
    public final int uniform_colortex6;
    public final int uniform_colortex7;
    public final int uniform_gdepthtex;
    public final int uniform_depthtex2;
    public final int uniform_tex;
    public final int uniform_heldItemId;
    public final int uniform_heldBlockLightValue;
    public final int uniform_fogMode;
    public final int uniform_fogColor;
    public final int uniform_skyColor;
    public final int uniform_worldTime;
    public final int uniform_moonPhase;
    public final int uniform_frameTimeCounter;
    public final int uniform_sunAngle;
    public final int uniform_shadowAngle;
    public final int uniform_rainStrength;
    public final int uniform_aspectRatio;
    public final int uniform_viewWidth;
    public final int uniform_viewHeight;
    public final int uniform_near;
    public final int uniform_far;
    public final int uniform_sunPosition;
    public final int uniform_moonPosition;
    public final int uniform_upPosition;
    public final int uniform_previousCameraPosition;
    public final int uniform_cameraPosition;
    public final int uniform_gbufferModelView;
    public final int uniform_gbufferModelViewInverse;
    public final int uniform_gbufferPreviousProjection;
    public final int uniform_gbufferProjection;
    public final int uniform_gbufferProjectionInverse;
    public final int uniform_gbufferPreviousModelView;
    public final int uniform_shadowProjection;
    public final int uniform_shadowProjectionInverse;
    public final int uniform_shadowModelView;
    public final int uniform_shadowModelViewInverse;
    public final int uniform_wetness;
    public final int uniform_eyeAltitude;
    public final int uniform_eyeBrightness;
    public final int uniform_eyeBrightnessSmooth;
    public final int uniform_terrainTextureSize;
    public final int uniform_terrainIconSize;
    public final int uniform_isEyeInWater;
    public final int uniform_hideGUI;
    public final int uniform_centerDepthSmooth;
    public final int uniform_atlasSize;

    public ShaderProgramData(int programID) {
        this.programIDGL = programID;
        this.uniform_texture = ARBShaderObjects.glGetUniformLocationARB(programID, "texture");
        this.uniform_lightmap = ARBShaderObjects.glGetUniformLocationARB(programID, "lightmap");
        this.uniform_normals = ARBShaderObjects.glGetUniformLocationARB(programID, "normals");
        this.uniform_specular = ARBShaderObjects.glGetUniformLocationARB(programID, "specular");
        this.uniform_shadow = ARBShaderObjects.glGetUniformLocationARB(programID, "shadow");
        this.uniform_watershadow = ARBShaderObjects.glGetUniformLocationARB(programID, "watershadow");
        this.uniform_shadowtex0 = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowtex0");
        this.uniform_shadowtex1 = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowtex1");
        this.uniform_depthtex0 = ARBShaderObjects.glGetUniformLocationARB(programID, "depthtex0");
        this.uniform_depthtex1 = ARBShaderObjects.glGetUniformLocationARB(programID, "depthtex1");
        this.uniform_shadowcolor = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowcolor");
        this.uniform_shadowcolor0 = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowcolor0");
        this.uniform_shadowcolor1 = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowcolor1");
        this.uniform_noisetex = ARBShaderObjects.glGetUniformLocationARB(programID, "noisetex");
        this.uniform_gcolor = ARBShaderObjects.glGetUniformLocationARB(programID, "gcolor");
        this.uniform_gdepth = ARBShaderObjects.glGetUniformLocationARB(programID, "gdepth");
        this.uniform_gnormal = ARBShaderObjects.glGetUniformLocationARB(programID, "gnormal");
        this.uniform_composite = ARBShaderObjects.glGetUniformLocationARB(programID, "composite");
        this.uniform_gaux1 = ARBShaderObjects.glGetUniformLocationARB(programID, "gaux1");
        this.uniform_gaux2 = ARBShaderObjects.glGetUniformLocationARB(programID, "gaux2");
        this.uniform_gaux3 = ARBShaderObjects.glGetUniformLocationARB(programID, "gaux3");
        this.uniform_gaux4 = ARBShaderObjects.glGetUniformLocationARB(programID, "gaux4");
        this.uniform_colortex0 = ARBShaderObjects.glGetUniformLocationARB(programID, "colortex0");
        this.uniform_colortex1 = ARBShaderObjects.glGetUniformLocationARB(programID, "colortex1");
        this.uniform_colortex2 = ARBShaderObjects.glGetUniformLocationARB(programID, "colortex2");
        this.uniform_colortex3 = ARBShaderObjects.glGetUniformLocationARB(programID, "colortex3");
        this.uniform_colortex4 = ARBShaderObjects.glGetUniformLocationARB(programID, "colortex4");
        this.uniform_colortex5 = ARBShaderObjects.glGetUniformLocationARB(programID, "colortex5");
        this.uniform_colortex6 = ARBShaderObjects.glGetUniformLocationARB(programID, "colortex6");
        this.uniform_colortex7 = ARBShaderObjects.glGetUniformLocationARB(programID, "colortex7");
        this.uniform_gdepthtex = ARBShaderObjects.glGetUniformLocationARB(programID, "gdepthtex");
        this.uniform_depthtex2 = ARBShaderObjects.glGetUniformLocationARB(programID, "depthtex2");
        this.uniform_tex = ARBShaderObjects.glGetUniformLocationARB(programID, "tex");
        this.uniform_heldItemId = ARBShaderObjects.glGetUniformLocationARB(programID, "heldItemId");
        this.uniform_heldBlockLightValue = ARBShaderObjects.glGetUniformLocationARB(programID, "heldBlockLightValue");
        this.uniform_fogMode = ARBShaderObjects.glGetUniformLocationARB(programID, "fogMode");
        this.uniform_fogColor = ARBShaderObjects.glGetUniformLocationARB(programID, "fogColor");
        this.uniform_skyColor = ARBShaderObjects.glGetUniformLocationARB(programID, "skyColor");
        this.uniform_worldTime = ARBShaderObjects.glGetUniformLocationARB(programID, "worldTime");
        this.uniform_moonPhase = ARBShaderObjects.glGetUniformLocationARB(programID, "moonPhase");
        this.uniform_frameTimeCounter = ARBShaderObjects.glGetUniformLocationARB(programID, "frameTimeCounter");
        this.uniform_sunAngle = ARBShaderObjects.glGetUniformLocationARB(programID, "sunAngle");
        this.uniform_shadowAngle = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowAngle");
        this.uniform_rainStrength = ARBShaderObjects.glGetUniformLocationARB(programID, "rainStrength");
        this.uniform_aspectRatio = ARBShaderObjects.glGetUniformLocationARB(programID, "aspectRatio");
        this.uniform_viewWidth = ARBShaderObjects.glGetUniformLocationARB(programID, "viewWidth");
        this.uniform_viewHeight = ARBShaderObjects.glGetUniformLocationARB(programID, "viewHeight");
        this.uniform_near = ARBShaderObjects.glGetUniformLocationARB(programID, "near");
        this.uniform_far = ARBShaderObjects.glGetUniformLocationARB(programID, "far");
        this.uniform_sunPosition = ARBShaderObjects.glGetUniformLocationARB(programID, "sunPosition");
        this.uniform_moonPosition = ARBShaderObjects.glGetUniformLocationARB(programID, "moonPosition");
        this.uniform_upPosition = ARBShaderObjects.glGetUniformLocationARB(programID, "upPosition");
        this.uniform_previousCameraPosition = ARBShaderObjects.glGetUniformLocationARB(programID, "previousCameraPosition");
        this.uniform_cameraPosition = ARBShaderObjects.glGetUniformLocationARB(programID, "cameraPosition");
        this.uniform_gbufferModelView = ARBShaderObjects.glGetUniformLocationARB(programID, "gbufferModelView");
        this.uniform_gbufferModelViewInverse = ARBShaderObjects.glGetUniformLocationARB(programID, "gbufferModelViewInverse");
        this.uniform_gbufferPreviousProjection = ARBShaderObjects.glGetUniformLocationARB(programID, "gbufferPreviousProjection");
        this.uniform_gbufferProjection = ARBShaderObjects.glGetUniformLocationARB(programID, "gbufferProjection");
        this.uniform_gbufferProjectionInverse = ARBShaderObjects.glGetUniformLocationARB(programID, "gbufferProjectionInverse");
        this.uniform_gbufferPreviousModelView = ARBShaderObjects.glGetUniformLocationARB(programID, "gbufferPreviousModelView");
        this.uniform_shadowProjection = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowProjection");
        this.uniform_shadowProjectionInverse = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowProjectionInverse");
        this.uniform_shadowModelView = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowModelView");
        this.uniform_shadowModelViewInverse = ARBShaderObjects.glGetUniformLocationARB(programID, "shadowModelViewInverse");
        this.uniform_wetness = ARBShaderObjects.glGetUniformLocationARB(programID, "wetness");
        this.uniform_eyeAltitude = ARBShaderObjects.glGetUniformLocationARB(programID, "eyeAltitude");
        this.uniform_eyeBrightness = ARBShaderObjects.glGetUniformLocationARB(programID, "eyeBrightness");
        this.uniform_eyeBrightnessSmooth = ARBShaderObjects.glGetUniformLocationARB(programID, "eyeBrightnessSmooth");
        this.uniform_terrainTextureSize = ARBShaderObjects.glGetUniformLocationARB(programID, "terrainTextureSize");
        this.uniform_terrainIconSize = ARBShaderObjects.glGetUniformLocationARB(programID, "terrainIconSize");
        this.uniform_isEyeInWater = ARBShaderObjects.glGetUniformLocationARB(programID, "isEyeInWater");
        this.uniform_hideGUI = ARBShaderObjects.glGetUniformLocationARB(programID, "hideGUI");
        this.uniform_centerDepthSmooth = ARBShaderObjects.glGetUniformLocationARB(programID, "centerDepthSmooth");
        this.uniform_atlasSize = ARBShaderObjects.glGetUniformLocationARB(programID, "atlasSize");
    }
}
