package net.optifine.render;

import java.util.LinkedList;

public class VboRange {
    private int position = -1;
    private int size = 0;
    private LinkedList<VboRange> parentList;

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPositionNext() {
        return this.position + this.size;
    }

    public void setParentList(LinkedList<VboRange> parentList) {
        this.parentList = parentList;
    }

    public VboRange getPrev() {
        if (this.parentList == null) {
            return null;
        }
        int index = this.parentList.indexOf(this);
        if (index <= 0) {
            return null;
        }
        return this.parentList.get(index - 1);
    }

    public VboRange getNext() {
        if (this.parentList == null) {
            return null;
        }
        int index = this.parentList.indexOf(this);
        if (index < 0 || index >= this.parentList.size() - 1) {
            return null;
        }
        return this.parentList.get(index + 1);
    }

    public String toString() {
        return this.position + "/" + this.size + "/" + (this.position + this.size);
    }
}
