package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelWolf;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderWolf;
import net.minecraft.entity.passive.EntityWolf;

public class ModelAdapterWolf extends ModelAdapter {
    public ModelAdapterWolf() {
        super(EntityWolf.class, "wolf", 0.5F);
    }

    public ModelBase makeModel() {
        return new ModelWolf();
    }

    public ModelRenderer getModelRenderer(ModelBase model, String modelPart) {
        if (model instanceof ModelWolf modelWolf) {

            switch (modelPart) {
                case "head":
                    return modelWolf.wolfHeadMain;
                case "body":
                    return modelWolf.wolfBody;
                case "leg1":
                    return modelWolf.wolfLeg1;
                case "leg2":
                    return modelWolf.wolfLeg2;
                case "leg3":
                    return modelWolf.wolfLeg3;
                case "leg4":
                    return modelWolf.wolfLeg4;
                case "tail":
                    return modelWolf.wolfTail;
                case "mane":
                    return modelWolf.wolfMane;
            }
        }
        return null;
    }

    public String[] getModelRendererNames() {
        return new String[]{"head", "body", "leg1", "leg2", "leg3", "leg4", "tail", "mane"};
    }

    public IEntityRenderer makeEntityRender(ModelBase modelBase, float shadowSize) {
        RenderManager rendermanager = Minecraft.getMinecraft().getRenderManager();
        return new RenderWolf(rendermanager, modelBase, shadowSize);
    }
}
