package net.optifine.entity.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelDragon;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderDragon;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.boss.EntityDragon;

public class ModelAdapterDragon extends ModelAdapter {
    public ModelAdapterDragon() {
        super(EntityDragon.class, "dragon", 0.5F);
    }

    public ModelBase makeModel() {
        return new ModelDragon(0.0F);
    }

    public ModelRenderer getModelRenderer(ModelBase model, String modelPart) {
        if (model instanceof ModelDragon modelDragon) {

            switch (modelPart) {
                case "head":
                    return modelDragon.head;
                case "spine":
                    return modelDragon.spine;
                case "jaw":
                    return modelDragon.jaw;
                case "body":
                    return modelDragon.body;
                case "rear_leg":
                    return modelDragon.rearLeg;
                case "front_leg":
                    return modelDragon.frontLeg;
                case "rear_leg_tip":
                    return modelDragon.rearLegTip;
                case "front_leg_tip":
                    return modelDragon.frontLegTip;
                case "rear_foot":
                    return modelDragon.rearFoot;
                case "front_foot":
                    return modelDragon.frontFoot;
                case "wing":
                    return modelDragon.wing;
                case "wing_tip":
                    return modelDragon.wingTip;
            }
        }
        return null;
    }

    public String[] getModelRendererNames() {
        return new String[]{"head", "spine", "jaw", "body", "rear_leg", "front_leg", "rear_leg_tip", "front_leg_tip", "rear_foot", "front_foot", "wing", "wing_tip"};
    }

    public IEntityRenderer makeEntityRender(ModelBase modelBase, float shadowSize) {
        RenderManager rendermanager = Minecraft.getMinecraft().getRenderManager();
        RenderDragon renderdragon = new RenderDragon(rendermanager);
        renderdragon.mainModel = modelBase;
        renderdragon.shadowSize = shadowSize;
        return renderdragon;
    }
}
