package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class StructureOceanMonumentPieces {
    public static void registerOceanMonumentPieces() {
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.MonumentBuilding.class, "OMB");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.MonumentCoreRoom.class, "OMCR");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.DoubleXRoom.class, "OMDXR");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.DoubleXYRoom.class, "OMDXYR");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.DoubleYRoom.class, "OMDYR");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.DoubleYZRoom.class, "OMDYZR");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.DoubleZRoom.class, "OMDZR");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.EntryRoom.class, "OMEntry");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.Penthouse.class, "OMPenthouse");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.SimpleRoom.class, "OMSimple");
        MapGenStructureIO.registerStructureComponent(StructureOceanMonumentPieces.SimpleTopRoom.class, "OMSimpleT");
    }

    interface MonumentRoomFitHelper {
        boolean fits(StructureOceanMonumentPieces.RoomDefinition definition);

        StructureOceanMonumentPieces.Piece create(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand);
    }

    public static class DoubleXRoom extends StructureOceanMonumentPieces.Piece {
        public DoubleXRoom() {
        }

        public DoubleXRoom(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            super(1, facing, room, 2, 1, 1);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition = this.roomDefinition.connections[EnumFacing.EAST.getIndex()];
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.roomDefinition;

            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 8, 0, structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 0, 0, structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.DOWN.getIndex()]);
            }

            if (structureoceanmonumentpieces$roomdefinition1.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 4, 1, 7, 4, 6, ROUGH_PRISMARINE);
            }

            if (structureoceanmonumentpieces$roomdefinition.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 8, 4, 1, 14, 4, 6, ROUGH_PRISMARINE);
            }

            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 0, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 3, 0, 15, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 15, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 7, 14, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 2, 0, 15, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 15, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 14, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 1, 0, 15, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 15, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 7, 14, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 0, 10, 1, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 2, 0, 9, 2, 3, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 3, 0, 10, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(worldIn, SEA_LANTERN, 6, 2, 3, structureBoundingBoxIn);
            this.setBlockState(worldIn, SEA_LANTERN, 9, 2, 3, structureBoundingBoxIn);

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, false);
            }

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 11, 1, 0, 12, 2, 0, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 11, 1, 7, 12, 2, 7, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 15, 1, 3, 15, 2, 4, false);
            }

            return true;
        }
    }

    public static class DoubleXYRoom extends StructureOceanMonumentPieces.Piece {
        public DoubleXYRoom() {
        }

        public DoubleXYRoom(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            super(1, facing, room, 2, 2, 1);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition = this.roomDefinition.connections[EnumFacing.EAST.getIndex()];
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.roomDefinition;
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition2 = structureoceanmonumentpieces$roomdefinition1.connections[EnumFacing.UP.getIndex()];
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition3 = structureoceanmonumentpieces$roomdefinition.connections[EnumFacing.UP.getIndex()];

            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 8, 0, structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 0, 0, structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.DOWN.getIndex()]);
            }

            if (structureoceanmonumentpieces$roomdefinition2.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 8, 1, 7, 8, 6, ROUGH_PRISMARINE);
            }

            if (structureoceanmonumentpieces$roomdefinition3.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 8, 8, 1, 14, 8, 6, ROUGH_PRISMARINE);
            }

            for (int i = 1; i <= 7; ++i) {
                IBlockState iblockstate = BRICKS_PRISMARINE;

                if (i == 2 || i == 6) {
                    iblockstate = ROUGH_PRISMARINE;
                }

                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i, 0, 0, i, 7, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, i, 0, 15, i, 7, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i, 0, 15, i, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i, 7, 14, i, 7, iblockstate, iblockstate, false);
            }

            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 3, 2, 7, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 2, 4, 7, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 5, 4, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 3, 13, 7, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 11, 1, 2, 12, 7, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 11, 1, 5, 12, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 3, 5, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 1, 3, 10, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 7, 2, 10, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 5, 2, 5, 7, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 5, 2, 10, 7, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 5, 5, 5, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 5, 5, 10, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 6, 6, 2, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 9, 6, 2, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 6, 6, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 9, 6, 5, structureBoundingBoxIn);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 3, 6, 4, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 4, 3, 10, 4, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(worldIn, SEA_LANTERN, 5, 4, 2, structureBoundingBoxIn);
            this.setBlockState(worldIn, SEA_LANTERN, 5, 4, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, SEA_LANTERN, 10, 4, 2, structureBoundingBoxIn);
            this.setBlockState(worldIn, SEA_LANTERN, 10, 4, 5, structureBoundingBoxIn);

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, false);
            }

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 11, 1, 0, 12, 2, 0, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 11, 1, 7, 12, 2, 7, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 15, 1, 3, 15, 2, 4, false);
            }

            if (structureoceanmonumentpieces$roomdefinition2.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 5, 0, 4, 6, 0, false);
            }

            if (structureoceanmonumentpieces$roomdefinition2.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 5, 7, 4, 6, 7, false);
            }

            if (structureoceanmonumentpieces$roomdefinition2.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 5, 3, 0, 6, 4, false);
            }

            if (structureoceanmonumentpieces$roomdefinition3.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 11, 5, 0, 12, 6, 0, false);
            }

            if (structureoceanmonumentpieces$roomdefinition3.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 11, 5, 7, 12, 6, 7, false);
            }

            if (structureoceanmonumentpieces$roomdefinition3.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 15, 5, 3, 15, 6, 4, false);
            }

            return true;
        }
    }

    public static class DoubleYRoom extends StructureOceanMonumentPieces.Piece {
        public DoubleYRoom() {
        }

        public DoubleYRoom(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            super(1, facing, room, 1, 2, 1);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 0, 0, this.roomDefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
            }

            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition = this.roomDefinition.connections[EnumFacing.UP.getIndex()];

            if (structureoceanmonumentpieces$roomdefinition.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 8, 1, 6, 8, 6, ROUGH_PRISMARINE);
            }

            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 4, 0, 0, 4, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 4, 0, 7, 4, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 0, 6, 4, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 7, 6, 4, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 4, 1, 2, 4, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 2, 1, 4, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 1, 5, 4, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 4, 2, 6, 4, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 4, 5, 2, 4, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 5, 1, 4, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 5, 5, 4, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 4, 5, 6, 4, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.roomDefinition;

            for (int i = 1; i <= 5; i += 4) {
                int j = 0;

                if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, i, j, 2, i + 2, j, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, i, j, 5, i + 2, j, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, i + 2, j, 4, i + 2, j, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i, j, 7, i + 2, j, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i + 1, j, 7, i + 1, j, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }

                j = 7;

                if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.NORTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, i, j, 2, i + 2, j, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, i, j, 5, i + 2, j, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, i + 2, j, 4, i + 2, j, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i, j, 7, i + 2, j, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i + 1, j, 7, i + 1, j, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }

                int k = 0;

                if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.WEST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i, 2, k, i + 2, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i, 5, k, i + 2, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i + 2, 3, k, i + 2, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i, 0, k, i + 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i + 1, 0, k, i + 1, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }

                k = 7;

                if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.EAST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i, 2, k, i + 2, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i, 5, k, i + 2, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i + 2, 3, k, i + 2, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i, 0, k, i + 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, k, i + 1, 0, k, i + 1, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }

                structureoceanmonumentpieces$roomdefinition1 = structureoceanmonumentpieces$roomdefinition;
            }

            return true;
        }
    }

    public static class DoubleYZRoom extends StructureOceanMonumentPieces.Piece {
        public DoubleYZRoom() {
        }

        public DoubleYZRoom(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            super(1, facing, room, 1, 2, 2);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition = this.roomDefinition.connections[EnumFacing.NORTH.getIndex()];
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.roomDefinition;
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition2 = structureoceanmonumentpieces$roomdefinition.connections[EnumFacing.UP.getIndex()];
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition3 = structureoceanmonumentpieces$roomdefinition1.connections[EnumFacing.UP.getIndex()];

            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 0, 8, structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 0, 0, structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.DOWN.getIndex()]);
            }

            if (structureoceanmonumentpieces$roomdefinition3.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 8, 1, 6, 8, 7, ROUGH_PRISMARINE);
            }

            if (structureoceanmonumentpieces$roomdefinition2.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 8, 8, 6, 8, 14, ROUGH_PRISMARINE);
            }

            for (int i = 1; i <= 7; ++i) {
                IBlockState iblockstate = BRICKS_PRISMARINE;

                if (i == 2 || i == 6) {
                    iblockstate = ROUGH_PRISMARINE;
                }

                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i, 0, 0, i, 15, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, i, 0, 7, i, 15, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i, 0, 6, i, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i, 15, 6, i, 15, iblockstate, iblockstate, false);
            }

            for (int j = 1; j <= 7; ++j) {
                IBlockState iblockstate1 = DARK_PRISMARINE;

                if (j == 2 || j == 6) {
                    iblockstate1 = SEA_LANTERN;
                }

                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, j, 7, 4, j, 8, iblockstate1, iblockstate1, false);
            }

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, false);
            }

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 15, 4, 2, 15, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 1, 11, 0, 2, 12, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 7, 1, 11, 7, 2, 12, false);
            }

            if (structureoceanmonumentpieces$roomdefinition3.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 5, 0, 4, 6, 0, false);
            }

            if (structureoceanmonumentpieces$roomdefinition3.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 7, 5, 3, 7, 6, 4, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 2, 6, 4, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 2, 6, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 5, 6, 3, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }

            if (structureoceanmonumentpieces$roomdefinition3.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 5, 3, 0, 6, 4, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 2, 2, 4, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 2, 1, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 5, 1, 3, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }

            if (structureoceanmonumentpieces$roomdefinition2.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 5, 15, 4, 6, 15, false);
            }

            if (structureoceanmonumentpieces$roomdefinition2.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 5, 11, 0, 6, 12, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 4, 10, 2, 4, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 10, 1, 3, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 13, 1, 3, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }

            if (structureoceanmonumentpieces$roomdefinition2.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 7, 5, 11, 7, 6, 12, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 4, 10, 6, 4, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 10, 6, 3, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 13, 6, 3, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }

            return true;
        }
    }

    public static class DoubleZRoom extends StructureOceanMonumentPieces.Piece {
        public DoubleZRoom() {
        }

        public DoubleZRoom(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            super(1, facing, room, 1, 1, 2);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition = this.roomDefinition.connections[EnumFacing.NORTH.getIndex()];
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition1 = this.roomDefinition;

            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 0, 8, structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 0, 0, structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.DOWN.getIndex()]);
            }

            if (structureoceanmonumentpieces$roomdefinition1.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 4, 1, 6, 4, 7, ROUGH_PRISMARINE);
            }

            if (structureoceanmonumentpieces$roomdefinition.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 4, 8, 6, 4, 14, ROUGH_PRISMARINE);
            }

            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 0, 3, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 0, 7, 3, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 7, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 15, 6, 3, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 15, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 0, 7, 2, 15, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 7, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 15, 6, 2, 15, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 0, 7, 1, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 7, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 15, 6, 1, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 1, 1, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 1, 6, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 1, 1, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 3, 1, 6, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 13, 1, 1, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 13, 6, 1, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 13, 1, 3, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 3, 13, 6, 3, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 6, 2, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 6, 5, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 9, 2, 3, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 9, 5, 3, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 6, 4, 2, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 9, 4, 2, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 2, 7, 2, 2, 8, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 7, 5, 2, 8, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(worldIn, SEA_LANTERN, 2, 2, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, SEA_LANTERN, 5, 2, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, SEA_LANTERN, 2, 2, 10, structureBoundingBoxIn);
            this.setBlockState(worldIn, SEA_LANTERN, 5, 2, 10, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 2, 3, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 5, 3, 5, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 2, 3, 10, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 5, 3, 10, structureBoundingBoxIn);

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, false);
            }

            if (structureoceanmonumentpieces$roomdefinition1.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 15, 4, 2, 15, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 1, 11, 0, 2, 12, false);
            }

            if (structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 7, 1, 11, 7, 2, 12, false);
            }

            return true;
        }
    }

    public static class EntryRoom extends StructureOceanMonumentPieces.Piece {
        public EntryRoom() {
        }

        public EntryRoom(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room) {
            super(1, facing, room, 1, 1, 1);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 2, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 3, 0, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 1, 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 2, 0, 7, 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 0, 7, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 7, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 2, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 0, 6, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);

            if (this.roomDefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, false);
            }

            if (this.roomDefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 1, 3, 1, 2, 4, false);
            }

            if (this.roomDefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 6, 1, 3, 7, 2, 4, false);
            }

            return true;
        }
    }

    static class FitSimpleRoomHelper implements StructureOceanMonumentPieces.MonumentRoomFitHelper {
        private FitSimpleRoomHelper() {
        }

        public boolean fits(StructureOceanMonumentPieces.RoomDefinition definition) {
            return true;
        }

        public StructureOceanMonumentPieces.Piece create(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            room.claimed = true;
            return new StructureOceanMonumentPieces.SimpleRoom(facing, room, rand);
        }
    }

    static class FitSimpleRoomTopHelper implements StructureOceanMonumentPieces.MonumentRoomFitHelper {
        private FitSimpleRoomTopHelper() {
        }

        public boolean fits(StructureOceanMonumentPieces.RoomDefinition definition) {
            return !definition.hasOpening[EnumFacing.WEST.getIndex()] && !definition.hasOpening[EnumFacing.EAST.getIndex()] && !definition.hasOpening[EnumFacing.NORTH.getIndex()] && !definition.hasOpening[EnumFacing.SOUTH.getIndex()] && !definition.hasOpening[EnumFacing.UP.getIndex()];
        }

        public StructureOceanMonumentPieces.Piece create(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            room.claimed = true;
            return new StructureOceanMonumentPieces.SimpleTopRoom(facing, room, rand);
        }
    }

    public static class MonumentBuilding extends StructureOceanMonumentPieces.Piece {
        private final List<StructureOceanMonumentPieces.Piece> childPieces = Lists.newArrayList();
        private StructureOceanMonumentPieces.RoomDefinition sourceRoom;
        private StructureOceanMonumentPieces.RoomDefinition coreRoom;

        public MonumentBuilding() {
        }

        public MonumentBuilding(Random rand, int chunkX, int chunkZ, EnumFacing facing) {
            super(0);
            this.coordBaseMode = facing;

            this.boundingBox = new StructureBoundingBox(chunkX, 39, chunkZ, chunkX + 58 - 1, 61, chunkZ + 58 - 1);

            List<StructureOceanMonumentPieces.RoomDefinition> list = this.generateRoomGraph(rand);
            this.sourceRoom.claimed = true;
            this.childPieces.add(new StructureOceanMonumentPieces.EntryRoom(this.coordBaseMode, this.sourceRoom));
            this.childPieces.add(new StructureOceanMonumentPieces.MonumentCoreRoom(this.coordBaseMode, this.coreRoom, rand));
            List<StructureOceanMonumentPieces.MonumentRoomFitHelper> list1 = Lists.newArrayList();
            list1.add(new StructureOceanMonumentPieces.XYDoubleRoomFitHelper());
            list1.add(new StructureOceanMonumentPieces.YZDoubleRoomFitHelper());
            list1.add(new StructureOceanMonumentPieces.ZDoubleRoomFitHelper());
            list1.add(new StructureOceanMonumentPieces.XDoubleRoomFitHelper());
            list1.add(new StructureOceanMonumentPieces.YDoubleRoomFitHelper());
            list1.add(new StructureOceanMonumentPieces.FitSimpleRoomTopHelper());
            list1.add(new StructureOceanMonumentPieces.FitSimpleRoomHelper());
            label319:

            for (StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition : list) {
                if (!structureoceanmonumentpieces$roomdefinition.claimed && !structureoceanmonumentpieces$roomdefinition.isSpecial()) {
                    Iterator<MonumentRoomFitHelper> iterator = list1.iterator();
                    StructureOceanMonumentPieces.MonumentRoomFitHelper structureoceanmonumentpieces$monumentroomfithelper;

                    do {
                        if (!iterator.hasNext()) {
                            continue label319;
                        }

                        structureoceanmonumentpieces$monumentroomfithelper = iterator.next();

                    } while (!structureoceanmonumentpieces$monumentroomfithelper.fits(structureoceanmonumentpieces$roomdefinition));

                    this.childPieces.add(structureoceanmonumentpieces$monumentroomfithelper.create(this.coordBaseMode, structureoceanmonumentpieces$roomdefinition, rand));
                }
            }

            int j = this.boundingBox.minY;
            int k = this.getXWithOffset(9, 22);
            int l = this.getZWithOffset(9, 22);

            for (StructureOceanMonumentPieces.Piece structureoceanmonumentpieces$piece : this.childPieces) {
                structureoceanmonumentpieces$piece.getBoundingBox().offset(k, j, l);
            }

            StructureBoundingBox structureboundingbox1 = StructureBoundingBox.createProper(this.getXWithOffset(1, 1), this.getYWithOffset(1), this.getZWithOffset(1, 1), this.getXWithOffset(23, 21), this.getYWithOffset(8), this.getZWithOffset(23, 21));
            StructureBoundingBox structureboundingbox2 = StructureBoundingBox.createProper(this.getXWithOffset(34, 1), this.getYWithOffset(1), this.getZWithOffset(34, 1), this.getXWithOffset(56, 21), this.getYWithOffset(8), this.getZWithOffset(56, 21));
            StructureBoundingBox structureboundingbox = StructureBoundingBox.createProper(this.getXWithOffset(22, 22), this.getYWithOffset(13), this.getZWithOffset(22, 22), this.getXWithOffset(35, 35), this.getYWithOffset(17), this.getZWithOffset(35, 35));
            int i = rand.nextInt();
            this.childPieces.add(new StructureOceanMonumentPieces.WingRoom(this.coordBaseMode, structureboundingbox1, i++));
            this.childPieces.add(new StructureOceanMonumentPieces.WingRoom(this.coordBaseMode, structureboundingbox2, i + 1));
            this.childPieces.add(new StructureOceanMonumentPieces.Penthouse(this.coordBaseMode, structureboundingbox));
        }

        private List<StructureOceanMonumentPieces.RoomDefinition> generateRoomGraph(Random rand) {
            StructureOceanMonumentPieces.RoomDefinition[] astructureoceanmonumentpieces$roomdefinition = new StructureOceanMonumentPieces.RoomDefinition[75];

            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int k = 0;
                    int l = getRoomIndex(i, k, j);
                    astructureoceanmonumentpieces$roomdefinition[l] = new StructureOceanMonumentPieces.RoomDefinition(l);
                }
            }

            for (int i2 = 0; i2 < 5; ++i2) {
                for (int l2 = 0; l2 < 4; ++l2) {
                    int k3 = 1;
                    int j4 = getRoomIndex(i2, k3, l2);
                    astructureoceanmonumentpieces$roomdefinition[j4] = new StructureOceanMonumentPieces.RoomDefinition(j4);
                }
            }

            for (int j2 = 1; j2 < 4; ++j2) {
                for (int i3 = 0; i3 < 2; ++i3) {
                    int l3 = 2;
                    int k4 = getRoomIndex(j2, l3, i3);
                    astructureoceanmonumentpieces$roomdefinition[k4] = new StructureOceanMonumentPieces.RoomDefinition(k4);
                }
            }

            this.sourceRoom = astructureoceanmonumentpieces$roomdefinition[GRIDROOM_SOURCE_INDEX];

            for (int k2 = 0; k2 < 5; ++k2) {
                for (int j3 = 0; j3 < 5; ++j3) {
                    for (int i4 = 0; i4 < 3; ++i4) {
                        int l4 = getRoomIndex(k2, i4, j3);

                        if (astructureoceanmonumentpieces$roomdefinition[l4] != null) {
                            for (EnumFacing enumfacing : EnumFacing.values()) {
                                int i1 = k2 + enumfacing.getFrontOffsetX();
                                int j1 = i4 + enumfacing.getFrontOffsetY();
                                int k1 = j3 + enumfacing.getFrontOffsetZ();

                                if (i1 >= 0 && i1 < 5 && k1 >= 0 && k1 < 5 && j1 >= 0 && j1 < 3) {
                                    int l1 = getRoomIndex(i1, j1, k1);

                                    if (astructureoceanmonumentpieces$roomdefinition[l1] != null) {
                                        if (k1 != j3) {
                                            astructureoceanmonumentpieces$roomdefinition[l4].setConnection(enumfacing.getOpposite(), astructureoceanmonumentpieces$roomdefinition[l1]);
                                        } else {
                                            astructureoceanmonumentpieces$roomdefinition[l4].setConnection(enumfacing, astructureoceanmonumentpieces$roomdefinition[l1]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition;
            astructureoceanmonumentpieces$roomdefinition[GRIDROOM_TOP_CONNECT_INDEX].setConnection(EnumFacing.UP, structureoceanmonumentpieces$roomdefinition = new StructureOceanMonumentPieces.RoomDefinition(1003));
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition1;
            astructureoceanmonumentpieces$roomdefinition[GRIDROOM_LEFTWING_CONNECT_INDEX].setConnection(EnumFacing.SOUTH, structureoceanmonumentpieces$roomdefinition1 = new StructureOceanMonumentPieces.RoomDefinition(1001));
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition2;
            astructureoceanmonumentpieces$roomdefinition[GRIDROOM_RIGHTWING_CONNECT_INDEX].setConnection(EnumFacing.SOUTH, structureoceanmonumentpieces$roomdefinition2 = new StructureOceanMonumentPieces.RoomDefinition(1002));
            structureoceanmonumentpieces$roomdefinition.claimed = true;
            structureoceanmonumentpieces$roomdefinition1.claimed = true;
            structureoceanmonumentpieces$roomdefinition2.claimed = true;
            this.sourceRoom.isSource = true;
            this.coreRoom = astructureoceanmonumentpieces$roomdefinition[getRoomIndex(rand.nextInt(4), 0, 2)];
            this.coreRoom.claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.NORTH.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.getIndex()].connections[EnumFacing.NORTH.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.UP.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.NORTH.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.getIndex()].connections[EnumFacing.NORTH.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            List<StructureOceanMonumentPieces.RoomDefinition> list = Lists.newArrayList();

            for (StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition4 : astructureoceanmonumentpieces$roomdefinition) {
                if (structureoceanmonumentpieces$roomdefinition4 != null) {
                    structureoceanmonumentpieces$roomdefinition4.updateOpenings();
                    list.add(structureoceanmonumentpieces$roomdefinition4);
                }
            }

            structureoceanmonumentpieces$roomdefinition.updateOpenings();
            Collections.shuffle(list, rand);
            int i5 = 1;

            for (StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition3 : list) {
                int j5 = 0;
                int k5 = 0;

                while (j5 < 2 && k5 < 5) {
                    ++k5;
                    int l5 = rand.nextInt(6);

                    if (structureoceanmonumentpieces$roomdefinition3.hasOpening[l5]) {
                        int i6 = EnumFacing.getFront(l5).getOpposite().getIndex();
                        structureoceanmonumentpieces$roomdefinition3.hasOpening[l5] = false;
                        structureoceanmonumentpieces$roomdefinition3.connections[l5].hasOpening[i6] = false;

                        if (structureoceanmonumentpieces$roomdefinition3.findSource(i5++) && structureoceanmonumentpieces$roomdefinition3.connections[l5].findSource(i5++)) {
                            ++j5;
                        } else {
                            structureoceanmonumentpieces$roomdefinition3.hasOpening[l5] = true;
                            structureoceanmonumentpieces$roomdefinition3.connections[l5].hasOpening[i6] = true;
                        }
                    }
                }
            }

            list.add(structureoceanmonumentpieces$roomdefinition);
            list.add(structureoceanmonumentpieces$roomdefinition1);
            list.add(structureoceanmonumentpieces$roomdefinition2);
            return list;
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            int i = Math.max(worldIn.getSeaLevel(), 64) - this.boundingBox.minY;
            this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 0, 0, 58, i, 58, false);
            this.generateWing(false, 0, worldIn, randomIn, structureBoundingBoxIn);
            this.generateWing(true, 33, worldIn, randomIn, structureBoundingBoxIn);
            this.generateEntranceArchs(worldIn, randomIn, structureBoundingBoxIn);
            this.generateEntranceWall(worldIn, randomIn, structureBoundingBoxIn);
            this.generateRoofPiece(worldIn, randomIn, structureBoundingBoxIn);
            this.generateLowerWall(worldIn, randomIn, structureBoundingBoxIn);
            this.generateMiddleWall(worldIn, randomIn, structureBoundingBoxIn);
            this.generateUpperWall(worldIn, randomIn, structureBoundingBoxIn);

            for (int j = 0; j < 7; ++j) {
                int k = 0;

                while (k < 7) {
                    if (k == 0 && j == 3) {
                        k = 6;
                    }

                    int l = j * 9;
                    int i1 = k * 9;

                    for (int j1 = 0; j1 < 4; ++j1) {
                        for (int k1 = 0; k1 < 4; ++k1) {
                            this.setBlockState(worldIn, BRICKS_PRISMARINE, l + j1, 0, i1 + k1, structureBoundingBoxIn);
                            this.replaceAirAndLiquidDownwards(worldIn, BRICKS_PRISMARINE, l + j1, -1, i1 + k1, structureBoundingBoxIn);
                        }
                    }

                    if (j != 0 && j != 6) {
                        k += 6;
                    } else {
                        ++k;
                    }
                }
            }

            for (int l1 = 0; l1 < 5; ++l1) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, -1 - l1, l1 * 2, -1 - l1, -1 - l1, 23, 58 + l1, false);
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 58 + l1, l1 * 2, -1 - l1, 58 + l1, 23, 58 + l1, false);
                this.generateWaterBox(worldIn, structureBoundingBoxIn, -l1, l1 * 2, -1 - l1, 57 + l1, 23, -1 - l1, false);
                this.generateWaterBox(worldIn, structureBoundingBoxIn, -l1, l1 * 2, 58 + l1, 57 + l1, 23, 58 + l1, false);
            }

            for (StructureOceanMonumentPieces.Piece structureoceanmonumentpieces$piece : this.childPieces) {
                if (structureoceanmonumentpieces$piece.getBoundingBox().intersectsWith(structureBoundingBoxIn)) {
                    structureoceanmonumentpieces$piece.addComponentParts(worldIn, randomIn, structureBoundingBoxIn);
                }
            }

            return true;
        }

        private void generateWing(boolean isLeftWing, int x, World worldIn, Random rand, StructureBoundingBox boundingBox) {
            int i = 24;

            if (this.doesChunkIntersect(boundingBox, x, 0, x + 23, 20)) {
                this.fillWithBlocks(worldIn, boundingBox, x, 0, 0, x + 24, 0, 20, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, x, 1, 0, x + 24, 10, 20, false);

                for (int j = 0; j < 4; ++j) {
                    this.fillWithBlocks(worldIn, boundingBox, x + j, j + 1, j, x + j, j + 1, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, x + j + 7, j + 5, j + 7, x + j + 7, j + 5, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, x + 17 - j, j + 5, j + 7, x + 17 - j, j + 5, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, x + 24 - j, j + 1, j, x + 24 - j, j + 1, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, x + j + 1, j + 1, j, x + 23 - j, j + 1, j, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, x + j + 8, j + 5, j + 7, x + 16 - j, j + 5, j + 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                this.fillWithBlocks(worldIn, boundingBox, x + 4, 4, 4, x + 6, 4, 20, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 7, 4, 4, x + 17, 4, 6, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 18, 4, 4, x + 20, 4, 20, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 11, 8, 11, x + 13, 8, 20, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(worldIn, DOT_DECO_DATA, x + 12, 9, 12, boundingBox);
                this.setBlockState(worldIn, DOT_DECO_DATA, x + 12, 9, 15, boundingBox);
                this.setBlockState(worldIn, DOT_DECO_DATA, x + 12, 9, 18, boundingBox);
                int j1 = isLeftWing ? x + 19 : x + 5;
                int k = isLeftWing ? x + 5 : x + 19;

                for (int l = 20; l >= 5; l -= 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, j1, 5, l, boundingBox);
                }

                for (int k1 = 19; k1 >= 7; k1 -= 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, k, 5, k1, boundingBox);
                }

                for (int l1 = 0; l1 < 4; ++l1) {
                    int i1 = isLeftWing ? x + (24 - (17 - l1 * 3)) : x + 17 - l1 * 3;
                    this.setBlockState(worldIn, DOT_DECO_DATA, i1, 5, 5, boundingBox);
                }

                this.setBlockState(worldIn, DOT_DECO_DATA, k, 5, 5, boundingBox);
                this.fillWithBlocks(worldIn, boundingBox, x + 11, 1, 12, x + 13, 7, 12, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 12, 1, 11, x + 12, 7, 13, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
        }

        private void generateEntranceArchs(World worldIn, Random rand, StructureBoundingBox boundingBox) {
            if (this.doesChunkIntersect(boundingBox, 22, 5, 35, 17)) {
                this.generateWaterBox(worldIn, boundingBox, 25, 0, 0, 32, 8, 20, false);

                for (int i = 0; i < 4; ++i) {
                    this.fillWithBlocks(worldIn, boundingBox, 24, 2, 5 + i * 4, 24, 4, 5 + i * 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, 22, 4, 5 + i * 4, 23, 4, 5 + i * 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.setBlockState(worldIn, BRICKS_PRISMARINE, 25, 5, 5 + i * 4, boundingBox);
                    this.setBlockState(worldIn, BRICKS_PRISMARINE, 26, 6, 5 + i * 4, boundingBox);
                    this.setBlockState(worldIn, SEA_LANTERN, 26, 5, 5 + i * 4, boundingBox);
                    this.fillWithBlocks(worldIn, boundingBox, 33, 2, 5 + i * 4, 33, 4, 5 + i * 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, 34, 4, 5 + i * 4, 35, 4, 5 + i * 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.setBlockState(worldIn, BRICKS_PRISMARINE, 32, 5, 5 + i * 4, boundingBox);
                    this.setBlockState(worldIn, BRICKS_PRISMARINE, 31, 6, 5 + i * 4, boundingBox);
                    this.setBlockState(worldIn, SEA_LANTERN, 31, 5, 5 + i * 4, boundingBox);
                    this.fillWithBlocks(worldIn, boundingBox, 27, 6, 5 + i * 4, 30, 6, 5 + i * 4, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }
            }
        }

        private void generateEntranceWall(World worldIn, Random rand, StructureBoundingBox boundingBox) {
            if (this.doesChunkIntersect(boundingBox, 15, 20, 42, 21)) {
                this.fillWithBlocks(worldIn, boundingBox, 15, 0, 21, 42, 0, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 26, 1, 21, 31, 3, 21, false);
                this.fillWithBlocks(worldIn, boundingBox, 21, 12, 21, 36, 12, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 17, 11, 21, 40, 11, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 16, 10, 21, 41, 10, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 15, 7, 21, 42, 9, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 16, 6, 21, 41, 6, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 17, 5, 21, 40, 5, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 21, 4, 21, 36, 4, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 22, 3, 21, 26, 3, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 31, 3, 21, 35, 3, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 23, 2, 21, 25, 2, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 32, 2, 21, 34, 2, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 28, 4, 20, 29, 4, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 27, 3, 21, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 30, 3, 21, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 26, 2, 21, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 31, 2, 21, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 25, 1, 21, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 32, 1, 21, boundingBox);

                for (int i = 0; i < 7; ++i) {
                    this.setBlockState(worldIn, DARK_PRISMARINE, 28 - i, 6 + i, 21, boundingBox);
                    this.setBlockState(worldIn, DARK_PRISMARINE, 29 + i, 6 + i, 21, boundingBox);
                }

                for (int j = 0; j < 4; ++j) {
                    this.setBlockState(worldIn, DARK_PRISMARINE, 28 - j, 9 + j, 21, boundingBox);
                    this.setBlockState(worldIn, DARK_PRISMARINE, 29 + j, 9 + j, 21, boundingBox);
                }

                this.setBlockState(worldIn, DARK_PRISMARINE, 28, 12, 21, boundingBox);
                this.setBlockState(worldIn, DARK_PRISMARINE, 29, 12, 21, boundingBox);

                for (int k = 0; k < 3; ++k) {
                    this.setBlockState(worldIn, DARK_PRISMARINE, 22 - k * 2, 8, 21, boundingBox);
                    this.setBlockState(worldIn, DARK_PRISMARINE, 22 - k * 2, 9, 21, boundingBox);
                    this.setBlockState(worldIn, DARK_PRISMARINE, 35 + k * 2, 8, 21, boundingBox);
                    this.setBlockState(worldIn, DARK_PRISMARINE, 35 + k * 2, 9, 21, boundingBox);
                }

                this.generateWaterBox(worldIn, boundingBox, 15, 13, 21, 42, 15, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 15, 1, 21, 15, 6, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 16, 1, 21, 16, 5, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 17, 1, 21, 20, 4, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 21, 1, 21, 21, 3, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 22, 1, 21, 22, 2, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 23, 1, 21, 24, 1, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 42, 1, 21, 42, 6, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 41, 1, 21, 41, 5, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 37, 1, 21, 40, 4, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 36, 1, 21, 36, 3, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 33, 1, 21, 34, 1, 21, false);
                this.generateWaterBox(worldIn, boundingBox, 35, 1, 21, 35, 2, 21, false);
            }
        }

        private void generateRoofPiece(World worldIn, Random rand, StructureBoundingBox boundingBox) {
            if (this.doesChunkIntersect(boundingBox, 21, 21, 36, 36)) {
                this.fillWithBlocks(worldIn, boundingBox, 21, 0, 22, 36, 0, 36, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 21, 1, 22, 36, 23, 36, false);

                for (int i = 0; i < 4; ++i) {
                    this.fillWithBlocks(worldIn, boundingBox, 21 + i, 13 + i, 21 + i, 36 - i, 13 + i, 21 + i, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, 21 + i, 13 + i, 36 - i, 36 - i, 13 + i, 36 - i, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, 21 + i, 13 + i, 22 + i, 21 + i, 13 + i, 35 - i, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, boundingBox, 36 - i, 13 + i, 22 + i, 36 - i, 13 + i, 35 - i, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                this.fillWithBlocks(worldIn, boundingBox, 25, 16, 25, 32, 16, 32, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 25, 17, 25, 25, 19, 25, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 32, 17, 25, 32, 19, 25, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 25, 17, 32, 25, 19, 32, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 32, 17, 32, 32, 19, 32, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 26, 20, 26, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 27, 21, 27, boundingBox);
                this.setBlockState(worldIn, SEA_LANTERN, 27, 20, 27, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 26, 20, 31, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 27, 21, 30, boundingBox);
                this.setBlockState(worldIn, SEA_LANTERN, 27, 20, 30, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 31, 20, 31, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 30, 21, 30, boundingBox);
                this.setBlockState(worldIn, SEA_LANTERN, 30, 20, 30, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 31, 20, 26, boundingBox);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 30, 21, 27, boundingBox);
                this.setBlockState(worldIn, SEA_LANTERN, 30, 20, 27, boundingBox);
                this.fillWithBlocks(worldIn, boundingBox, 28, 21, 27, 29, 21, 27, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 27, 21, 28, 27, 21, 29, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 28, 21, 30, 29, 21, 30, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 30, 21, 28, 30, 21, 29, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
        }

        private void generateLowerWall(World worldIn, Random rand, StructureBoundingBox boundingBox) {
            if (this.doesChunkIntersect(boundingBox, 0, 21, 6, 58)) {
                this.fillWithBlocks(worldIn, boundingBox, 0, 0, 21, 6, 0, 57, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 0, 1, 21, 6, 7, 57, false);
                this.fillWithBlocks(worldIn, boundingBox, 4, 4, 21, 6, 4, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);

                for (int i = 0; i < 4; ++i) {
                    this.fillWithBlocks(worldIn, boundingBox, i, i + 1, 21, i, i + 1, 57 - i, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                for (int j = 23; j < 53; j += 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, 5, 5, j, boundingBox);
                }

                this.setBlockState(worldIn, DOT_DECO_DATA, 5, 5, 52, boundingBox);

                for (int k = 0; k < 4; ++k) {
                    this.fillWithBlocks(worldIn, boundingBox, k, k + 1, 21, k, k + 1, 57 - k, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                this.fillWithBlocks(worldIn, boundingBox, 4, 1, 52, 6, 3, 52, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 5, 1, 51, 5, 3, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }

            if (this.doesChunkIntersect(boundingBox, 51, 21, 58, 58)) {
                this.fillWithBlocks(worldIn, boundingBox, 51, 0, 21, 57, 0, 57, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 51, 1, 21, 57, 7, 57, false);
                this.fillWithBlocks(worldIn, boundingBox, 51, 4, 21, 53, 4, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);

                for (int l = 0; l < 4; ++l) {
                    this.fillWithBlocks(worldIn, boundingBox, 57 - l, l + 1, 21, 57 - l, l + 1, 57 - l, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                for (int i1 = 23; i1 < 53; i1 += 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, 52, 5, i1, boundingBox);
                }

                this.setBlockState(worldIn, DOT_DECO_DATA, 52, 5, 52, boundingBox);
                this.fillWithBlocks(worldIn, boundingBox, 51, 1, 52, 53, 3, 52, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 52, 1, 51, 52, 3, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }

            if (this.doesChunkIntersect(boundingBox, 0, 51, 57, 57)) {
                this.fillWithBlocks(worldIn, boundingBox, 7, 0, 51, 50, 0, 57, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 7, 1, 51, 50, 10, 57, false);

                for (int j1 = 0; j1 < 4; ++j1) {
                    this.fillWithBlocks(worldIn, boundingBox, j1 + 1, j1 + 1, 57 - j1, 56 - j1, j1 + 1, 57 - j1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
            }
        }

        private void generateMiddleWall(World worldIn, Random rand, StructureBoundingBox boundingBox) {
            if (this.doesChunkIntersect(boundingBox, 7, 21, 13, 50)) {
                this.fillWithBlocks(worldIn, boundingBox, 7, 0, 21, 13, 0, 50, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 7, 1, 21, 13, 10, 50, false);
                this.fillWithBlocks(worldIn, boundingBox, 11, 8, 21, 13, 8, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);

                for (int i = 0; i < 4; ++i) {
                    this.fillWithBlocks(worldIn, boundingBox, i + 7, i + 5, 21, i + 7, i + 5, 54, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                for (int j = 21; j <= 45; j += 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, 12, 9, j, boundingBox);
                }
            }

            if (this.doesChunkIntersect(boundingBox, 44, 21, 50, 54)) {
                this.fillWithBlocks(worldIn, boundingBox, 44, 0, 21, 50, 0, 50, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 44, 1, 21, 50, 10, 50, false);
                this.fillWithBlocks(worldIn, boundingBox, 44, 8, 21, 46, 8, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);

                for (int k = 0; k < 4; ++k) {
                    this.fillWithBlocks(worldIn, boundingBox, 50 - k, k + 5, 21, 50 - k, k + 5, 54, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                for (int l = 21; l <= 45; l += 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, 45, 9, l, boundingBox);
                }
            }

            if (this.doesChunkIntersect(boundingBox, 8, 44, 49, 54)) {
                this.fillWithBlocks(worldIn, boundingBox, 14, 0, 44, 43, 0, 50, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 14, 1, 44, 43, 10, 50, false);

                for (int i1 = 12; i1 <= 45; i1 += 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, i1, 9, 45, boundingBox);
                    this.setBlockState(worldIn, DOT_DECO_DATA, i1, 9, 52, boundingBox);

                    if (i1 == 12 || i1 == 18 || i1 == 24 || i1 == 33 || i1 == 39 || i1 == 45) {
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 9, 47, boundingBox);
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 9, 50, boundingBox);
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 10, 45, boundingBox);
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 10, 46, boundingBox);
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 10, 51, boundingBox);
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 10, 52, boundingBox);
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 11, 47, boundingBox);
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 11, 50, boundingBox);
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 12, 48, boundingBox);
                        this.setBlockState(worldIn, DOT_DECO_DATA, i1, 12, 49, boundingBox);
                    }
                }

                for (int j1 = 0; j1 < 3; ++j1) {
                    this.fillWithBlocks(worldIn, boundingBox, 8 + j1, 5 + j1, 54, 49 - j1, 5 + j1, 54, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }

                this.fillWithBlocks(worldIn, boundingBox, 11, 8, 54, 46, 8, 54, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 14, 8, 44, 43, 8, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
        }

        private void generateUpperWall(World worldIn, Random rand, StructureBoundingBox boundingBox) {
            if (this.doesChunkIntersect(boundingBox, 14, 21, 20, 43)) {
                this.fillWithBlocks(worldIn, boundingBox, 14, 0, 21, 20, 0, 43, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 14, 1, 22, 20, 14, 43, false);
                this.fillWithBlocks(worldIn, boundingBox, 18, 12, 22, 20, 12, 39, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 18, 12, 21, 20, 12, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);

                for (int i = 0; i < 4; ++i) {
                    this.fillWithBlocks(worldIn, boundingBox, i + 14, i + 9, 21, i + 14, i + 9, 43 - i, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                for (int j = 23; j <= 39; j += 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, 19, 13, j, boundingBox);
                }
            }

            if (this.doesChunkIntersect(boundingBox, 37, 21, 43, 43)) {
                this.fillWithBlocks(worldIn, boundingBox, 37, 0, 21, 43, 0, 43, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 37, 1, 22, 43, 14, 43, false);
                this.fillWithBlocks(worldIn, boundingBox, 37, 12, 22, 39, 12, 39, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, 37, 12, 21, 39, 12, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);

                for (int k = 0; k < 4; ++k) {
                    this.fillWithBlocks(worldIn, boundingBox, 43 - k, k + 9, 21, 43 - k, k + 9, 43 - k, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                for (int l = 23; l <= 39; l += 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, 38, 13, l, boundingBox);
                }
            }

            if (this.doesChunkIntersect(boundingBox, 15, 37, 42, 43)) {
                this.fillWithBlocks(worldIn, boundingBox, 21, 0, 37, 36, 0, 43, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(worldIn, boundingBox, 21, 1, 37, 36, 14, 43, false);
                this.fillWithBlocks(worldIn, boundingBox, 21, 12, 37, 36, 12, 39, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);

                for (int i1 = 0; i1 < 4; ++i1) {
                    this.fillWithBlocks(worldIn, boundingBox, 15 + i1, i1 + 9, 43 - i1, 42 - i1, i1 + 9, 43 - i1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                for (int j1 = 21; j1 <= 36; j1 += 3) {
                    this.setBlockState(worldIn, DOT_DECO_DATA, j1, 13, 38, boundingBox);
                }
            }
        }
    }

    public static class MonumentCoreRoom extends StructureOceanMonumentPieces.Piece {
        public MonumentCoreRoom() {
        }

        public MonumentCoreRoom(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            super(1, facing, room, 2, 2, 2);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 8, 0, 14, 8, 14, ROUGH_PRISMARINE);
            int i = 7;
            IBlockState iblockstate = BRICKS_PRISMARINE;
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, i, 0, 0, i, 15, iblockstate, iblockstate, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, i, 0, 15, i, 15, iblockstate, iblockstate, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i, 0, 15, i, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i, 15, 14, i, 15, iblockstate, iblockstate, false);

            for (i = 1; i <= 6; ++i) {
                iblockstate = BRICKS_PRISMARINE;

                if (i == 2 || i == 6) {
                    iblockstate = ROUGH_PRISMARINE;
                }

                for (int j = 0; j <= 15; j += 15) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j, i, 0, j, i, 1, iblockstate, iblockstate, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j, i, 6, j, i, 9, iblockstate, iblockstate, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j, i, 14, j, i, 15, iblockstate, iblockstate, false);
                }

                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i, 0, 1, i, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, i, 0, 9, i, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 14, i, 0, 14, i, 0, iblockstate, iblockstate, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, i, 15, 14, i, 15, iblockstate, iblockstate, false);
            }

            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 3, 6, 9, 6, 9, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 4, 7, 8, 5, 8, Blocks.gold_block.getDefaultState(), Blocks.gold_block.getDefaultState(), false);

            for (i = 3; i <= 6; i += 3) {
                for (int k = 6; k <= 9; k += 3) {
                    this.setBlockState(worldIn, SEA_LANTERN, k, i, 6, structureBoundingBoxIn);
                    this.setBlockState(worldIn, SEA_LANTERN, k, i, 9, structureBoundingBoxIn);
                }
            }

            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 6, 5, 2, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 9, 5, 2, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 1, 6, 10, 2, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 1, 9, 10, 2, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 5, 6, 2, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 1, 5, 9, 2, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 10, 6, 2, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 1, 10, 9, 2, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 5, 5, 6, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 10, 5, 6, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 2, 5, 10, 6, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 2, 10, 10, 6, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 7, 1, 5, 7, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 7, 1, 10, 7, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 7, 9, 5, 7, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 7, 9, 10, 7, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 7, 5, 6, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 7, 10, 6, 7, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 7, 5, 14, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 7, 10, 14, 7, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 2, 2, 1, 3, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 2, 3, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 2, 13, 1, 3, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 12, 1, 2, 12, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 12, 2, 1, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 13, 3, 1, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 12, 13, 1, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 12, 1, 13, 12, 1, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            return true;
        }
    }

    public static class Penthouse extends StructureOceanMonumentPieces.Piece {
        public Penthouse() {
        }

        public Penthouse(EnumFacing facing, StructureBoundingBox boundingBox) {
            super(facing, boundingBox);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, -1, 2, 11, -1, 11, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, -1, 0, 1, -1, 11, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 12, -1, 0, 13, -1, 11, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, -1, 0, 11, -1, 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, -1, 12, 11, -1, 13, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 0, 0, 0, 0, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 0, 0, 13, 0, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 0, 0, 12, 0, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 0, 13, 12, 0, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);

            for (int i = 2; i <= 11; i += 3) {
                this.setBlockState(worldIn, SEA_LANTERN, 0, 0, i, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 13, 0, i, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, i, 0, 0, structureBoundingBoxIn);
            }

            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 0, 3, 4, 0, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 0, 3, 11, 0, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 4, 0, 9, 9, 0, 11, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 5, 0, 8, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 8, 0, 8, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 10, 0, 10, structureBoundingBoxIn);
            this.setBlockState(worldIn, BRICKS_PRISMARINE, 3, 0, 10, structureBoundingBoxIn);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 0, 3, 3, 0, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 0, 3, 10, 0, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 0, 10, 7, 0, 10, DARK_PRISMARINE, DARK_PRISMARINE, false);
            int l = 3;

            for (int j = 0; j < 2; ++j) {
                for (int k = 2; k <= 8; k += 3) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, l, 0, k, l, 2, k, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                l = 10;
            }

            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 0, 10, 5, 2, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 8, 0, 10, 8, 2, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, -1, 7, 7, -1, 8, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.generateWaterBox(worldIn, structureBoundingBoxIn, 6, -1, 3, 7, -1, 4, false);
            this.spawnElder(worldIn, structureBoundingBoxIn, 6, 1, 6);
            return true;
        }
    }

    public abstract static class Piece extends StructureComponent {
        protected static final IBlockState ROUGH_PRISMARINE = Blocks.prismarine.getStateFromMeta(BlockPrismarine.ROUGH_META);
        protected static final IBlockState BRICKS_PRISMARINE = Blocks.prismarine.getStateFromMeta(BlockPrismarine.BRICKS_META);
        protected static final IBlockState DARK_PRISMARINE = Blocks.prismarine.getStateFromMeta(BlockPrismarine.DARK_META);
        protected static final IBlockState DOT_DECO_DATA = BRICKS_PRISMARINE;
        protected static final IBlockState SEA_LANTERN = Blocks.sea_lantern.getDefaultState();
        protected static final IBlockState WATER = Blocks.water.getDefaultState();
        protected static final int GRIDROOM_SOURCE_INDEX = getRoomIndex(2, 0, 0);
        protected static final int GRIDROOM_TOP_CONNECT_INDEX = getRoomIndex(2, 2, 0);
        protected static final int GRIDROOM_LEFTWING_CONNECT_INDEX = getRoomIndex(0, 1, 0);
        protected static final int GRIDROOM_RIGHTWING_CONNECT_INDEX = getRoomIndex(4, 1, 0);
        protected StructureOceanMonumentPieces.RoomDefinition roomDefinition;

        public Piece() {
            super(0);
        }

        public Piece(int type) {
            super(type);
        }

        public Piece(EnumFacing facing, StructureBoundingBox boundingBox) {
            super(1);
            this.coordBaseMode = facing;
            this.boundingBox = boundingBox;
        }

        protected Piece(int type, EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, int chunkX, int chunkY, int chunkZ) {
            super(type);
            this.coordBaseMode = facing;
            this.roomDefinition = room;
            int i = room.index;
            int j = i % 5;
            int k = i / 5 % 5;
            int l = i / 25;

            if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH) {
                this.boundingBox = new StructureBoundingBox(0, 0, 0, chunkZ * 8 - 1, chunkY * 4 - 1, chunkX * 8 - 1);
            } else {
                this.boundingBox = new StructureBoundingBox(0, 0, 0, chunkX * 8 - 1, chunkY * 4 - 1, chunkZ * 8 - 1);
            }

            switch (facing) {
                case NORTH:
                    this.boundingBox.offset(j * 8, l * 4, -(k + chunkZ) * 8 + 1);
                    break;

                case SOUTH:
                    this.boundingBox.offset(j * 8, l * 4, k * 8);
                    break;

                case WEST:
                    this.boundingBox.offset(-(k + chunkZ) * 8 + 1, l * 4, j * 8);
                    break;

                default:
                    this.boundingBox.offset(k * 8, l * 4, j * 8);
            }
        }

        protected static int getRoomIndex(int x, int y, int z) {
            return y * 25 + z * 5 + x;
        }

        protected void writeStructureToNBT(NBTTagCompound tagCompound) {
        }

        protected void readStructureFromNBT(NBTTagCompound tagCompound) {
        }

        protected void generateWaterBox(World worldIn, StructureBoundingBox boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean replaceAir) {
            for (int i = minY; i <= maxY; ++i) {
                for (int j = minX; j <= maxX; ++j) {
                    for (int k = minZ; k <= maxZ; ++k) {
                        if (!replaceAir || this.getBlockStateFromPos(worldIn, j, i, k, boundingBox).getBlock().getMaterial() != Material.air) {
                            if (this.getYWithOffset(i) >= worldIn.getSeaLevel()) {
                                this.setBlockState(worldIn, Blocks.air.getDefaultState(), j, i, k, boundingBox);
                            } else {
                                this.setBlockState(worldIn, WATER, j, i, k, boundingBox);
                            }
                        }
                    }
                }
            }
        }

        protected void generateDefaultFloor(World worldIn, StructureBoundingBox boundingBox, int x, int z, boolean hasOpeningDownwards) {
            if (hasOpeningDownwards) {
                this.fillWithBlocks(worldIn, boundingBox, x, 0, z, x + 2, 0, z + 8 - 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 5, 0, z, x + 8 - 1, 0, z + 8 - 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 3, 0, z, x + 4, 0, z + 2, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 3, 0, z + 5, x + 4, 0, z + 8 - 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 3, 0, z + 2, x + 4, 0, z + 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 3, 0, z + 5, x + 4, 0, z + 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 2, 0, z + 3, x + 2, 0, z + 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, boundingBox, x + 5, 0, z + 3, x + 5, 0, z + 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            } else {
                this.fillWithBlocks(worldIn, boundingBox, x, 0, z, x + 8 - 1, 0, z + 8 - 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
        }

        protected void generateBoxOnFillOnly(World worldIn, StructureBoundingBox boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IBlockState state) {
            for (int i = minY; i <= maxY; ++i) {
                for (int j = minX; j <= maxX; ++j) {
                    for (int k = minZ; k <= maxZ; ++k) {
                        if (this.getBlockStateFromPos(worldIn, j, i, k, boundingBox) == WATER) {
                            this.setBlockState(worldIn, state, j, i, k, boundingBox);
                        }
                    }
                }
            }
        }

        protected boolean doesChunkIntersect(StructureBoundingBox boundingBox, int x1, int z1, int x2, int z2) {
            int i = this.getXWithOffset(x1, z1);
            int j = this.getZWithOffset(x1, z1);
            int k = this.getXWithOffset(x2, z2);
            int l = this.getZWithOffset(x2, z2);
            return boundingBox.intersectsWith(Math.min(i, k), Math.min(j, l), Math.max(i, k), Math.max(j, l));
        }

        protected void spawnElder(World worldIn, StructureBoundingBox boundingBox, int x, int y, int z) {
            int i = this.getXWithOffset(x, z);
            int j = this.getYWithOffset(y);
            int k = this.getZWithOffset(x, z);

            if (boundingBox.isVecInside(new BlockPos(i, j, k))) {
                EntityGuardian entityguardian = new EntityGuardian(worldIn);
                entityguardian.setElder(true);
                entityguardian.heal(entityguardian.getMaxHealth());
                entityguardian.setLocationAndAngles((double) i + 0.5D, j, (double) k + 0.5D, 0.0F, 0.0F);
                entityguardian.onInitialSpawn(worldIn.getDifficultyForLocation(new BlockPos(entityguardian)), null);
                worldIn.spawnEntityInWorld(entityguardian);
            } else {
            }
        }
    }

    public static class RoomDefinition {
        final int index;
        final StructureOceanMonumentPieces.RoomDefinition[] connections = new StructureOceanMonumentPieces.RoomDefinition[6];
        final boolean[] hasOpening = new boolean[6];
        boolean claimed;
        boolean isSource;
        int scanIndex;

        public RoomDefinition(int index) {
            this.index = index;
        }

        public void setConnection(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room) {
            this.connections[facing.getIndex()] = room;
            room.connections[facing.getOpposite().getIndex()] = this;
        }

        public void updateOpenings() {
            for (int i = 0; i < 6; ++i) {
                this.hasOpening[i] = this.connections[i] != null;
            }
        }

        public boolean findSource(int index) {
            if (this.isSource) {
                return true;
            } else {
                this.scanIndex = index;

                for (int i = 0; i < 6; ++i) {
                    if (this.connections[i] != null && this.hasOpening[i] && this.connections[i].scanIndex != index && this.connections[i].findSource(index)) {
                        return true;
                    }
                }

                return false;
            }
        }

        public boolean isSpecial() {
            return this.index >= 75;
        }

        public int countOpenings() {
            int i = 0;

            for (int j = 0; j < 6; ++j) {
                if (this.hasOpening[j]) {
                    ++i;
                }
            }

            return i;
        }
    }

    public static class SimpleRoom extends StructureOceanMonumentPieces.Piece {
        private int mainDesign;

        public SimpleRoom() {
        }

        public SimpleRoom(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            super(1, facing, room, 1, 1, 1);
            this.mainDesign = rand.nextInt(3);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 0, 0, this.roomDefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
            }

            if (this.roomDefinition.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 4, 1, 6, 4, 6, ROUGH_PRISMARINE);
            }

            boolean flag = this.mainDesign != 0 && randomIn.nextBoolean() && !this.roomDefinition.hasOpening[EnumFacing.DOWN.getIndex()] && !this.roomDefinition.hasOpening[EnumFacing.UP.getIndex()] && this.roomDefinition.countOpenings() > 1;

            if (this.mainDesign == 0) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 2, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 2, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 2, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 2, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(worldIn, SEA_LANTERN, 1, 2, 1, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 0, 7, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 3, 0, 7, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 0, 7, 2, 2, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 0, 6, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(worldIn, SEA_LANTERN, 6, 2, 1, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 5, 2, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 5, 2, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 5, 0, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 2, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(worldIn, SEA_LANTERN, 1, 2, 6, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 5, 7, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 3, 5, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 5, 7, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 2, 7, 6, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(worldIn, SEA_LANTERN, 6, 2, 6, structureBoundingBoxIn);

                if (this.roomDefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 0, 4, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 0, 4, 3, 1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 0, 4, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 1, 1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                if (this.roomDefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 7, 4, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 6, 4, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 7, 4, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 6, 4, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                if (this.roomDefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 3, 0, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 3, 1, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 3, 0, 2, 4, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 3, 1, 1, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                if (this.roomDefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 3, 7, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 3, 3, 7, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 3, 7, 2, 4, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 3, 7, 1, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
            } else if (this.mainDesign == 1) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 2, 2, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 2, 1, 5, 2, 3, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 5, 5, 3, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 5, 1, 2, 5, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.setBlockState(worldIn, SEA_LANTERN, 2, 2, 2, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 2, 2, 5, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 5, 2, 5, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 5, 2, 2, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 1, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 3, 1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 7, 1, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 6, 0, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 7, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 6, 7, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 1, 0, 7, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 1, 7, 3, 1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.setBlockState(worldIn, ROUGH_PRISMARINE, 1, 2, 0, structureBoundingBoxIn);
                this.setBlockState(worldIn, ROUGH_PRISMARINE, 0, 2, 1, structureBoundingBoxIn);
                this.setBlockState(worldIn, ROUGH_PRISMARINE, 1, 2, 7, structureBoundingBoxIn);
                this.setBlockState(worldIn, ROUGH_PRISMARINE, 0, 2, 6, structureBoundingBoxIn);
                this.setBlockState(worldIn, ROUGH_PRISMARINE, 6, 2, 7, structureBoundingBoxIn);
                this.setBlockState(worldIn, ROUGH_PRISMARINE, 7, 2, 6, structureBoundingBoxIn);
                this.setBlockState(worldIn, ROUGH_PRISMARINE, 6, 2, 0, structureBoundingBoxIn);
                this.setBlockState(worldIn, ROUGH_PRISMARINE, 7, 2, 1, structureBoundingBoxIn);

                if (!this.roomDefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 6, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 6, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 6, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                if (!this.roomDefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 7, 6, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 6, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 7, 6, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                if (!this.roomDefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 1, 0, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 1, 0, 2, 6, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 1, 0, 1, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                if (!this.roomDefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 1, 7, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 1, 7, 2, 6, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 1, 7, 1, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
            } else if (this.mainDesign == 2) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 0, 7, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 6, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 7, 6, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 0, 7, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 6, 2, 0, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 6, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 0, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 0, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 6, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 7, 6, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);

                if (this.roomDefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                    this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
                }

                if (this.roomDefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                    this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, false);
                }

                if (this.roomDefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                    this.generateWaterBox(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, false);
                }

                if (this.roomDefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                    this.generateWaterBox(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, false);
                }
            }

            if (flag) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 3, 4, 1, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 2, 3, 4, 2, 4, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 3, 3, 4, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }

            return true;
        }
    }

    public static class SimpleTopRoom extends StructureOceanMonumentPieces.Piece {
        public SimpleTopRoom() {
        }

        public SimpleTopRoom(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            super(1, facing, room, 1, 1, 1);
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(worldIn, structureBoundingBoxIn, 0, 0, this.roomDefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
            }

            if (this.roomDefinition.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(worldIn, structureBoundingBoxIn, 1, 4, 1, 6, 4, 6, ROUGH_PRISMARINE);
            }

            for (int i = 1; i <= 6; ++i) {
                for (int j = 1; j <= 6; ++j) {
                    if (randomIn.nextInt(3) != 0) {
                        int k = 2 + (randomIn.nextInt(4) == 0 ? 0 : 1);
                        this.fillWithBlocks(worldIn, structureBoundingBoxIn, i, k, j, i, 3, j, Blocks.sponge.getStateFromMeta(1), Blocks.sponge.getStateFromMeta(1), false);
                    }
                }
            }

            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 0, 0, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 0, 7, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 0, 6, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 1, 7, 6, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 2, 0, 0, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 2, 0, 7, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 0, 6, 2, 0, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 2, 7, 6, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 3, 0, 0, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 0, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 0, 6, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 1, 3, 7, 6, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 0, 1, 3, 0, 2, 4, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 3, 7, 2, 4, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(worldIn, structureBoundingBoxIn, 3, 1, 7, 4, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);

            if (this.roomDefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(worldIn, structureBoundingBoxIn, 3, 1, 0, 4, 2, 0, false);
            }

            return true;
        }
    }

    public static class WingRoom extends StructureOceanMonumentPieces.Piece {
        private int mainDesign;

        public WingRoom() {
        }

        public WingRoom(EnumFacing facing, StructureBoundingBox boundingBox, int mainDesign) {
            super(facing, boundingBox);
            this.mainDesign = mainDesign & 1;
        }

        public boolean addComponentParts(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (this.mainDesign == 0) {
                for (int i = 0; i < 4; ++i) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10 - i, 3 - i, 20 - i, 12 + i, 3 - i, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }

                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 0, 6, 15, 0, 16, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 0, 6, 6, 3, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 16, 0, 6, 16, 3, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 7, 7, 1, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 1, 7, 15, 1, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 1, 6, 9, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 6, 15, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 8, 1, 7, 9, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 1, 7, 14, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 0, 5, 13, 0, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 10, 0, 7, 12, 0, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 8, 0, 10, 8, 0, 12, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 14, 0, 10, 14, 0, 12, DARK_PRISMARINE, DARK_PRISMARINE, false);

                for (int i1 = 18; i1 >= 7; i1 -= 3) {
                    this.setBlockState(worldIn, SEA_LANTERN, 6, 3, i1, structureBoundingBoxIn);
                    this.setBlockState(worldIn, SEA_LANTERN, 16, 3, i1, structureBoundingBoxIn);
                }

                this.setBlockState(worldIn, SEA_LANTERN, 10, 0, 10, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 12, 0, 10, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 10, 0, 12, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 12, 0, 12, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 8, 3, 6, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 14, 3, 6, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 4, 2, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 4, 1, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 4, 0, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 18, 2, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 18, 1, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 18, 0, 4, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 4, 2, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 4, 1, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 4, 0, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 18, 2, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, SEA_LANTERN, 18, 1, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 18, 0, 18, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 9, 7, 20, structureBoundingBoxIn);
                this.setBlockState(worldIn, BRICKS_PRISMARINE, 13, 7, 20, structureBoundingBoxIn);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 6, 0, 21, 7, 4, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 15, 0, 21, 16, 4, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.spawnElder(worldIn, structureBoundingBoxIn, 11, 2, 16);
            } else if (this.mainDesign == 1) {
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 3, 18, 13, 3, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 9, 0, 18, 9, 2, 18, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 13, 0, 18, 13, 2, 18, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                int j1 = 9;
                int j = 20;
                int k = 5;

                for (int l = 0; l < 2; ++l) {
                    this.setBlockState(worldIn, BRICKS_PRISMARINE, j1, k + 1, j, structureBoundingBoxIn);
                    this.setBlockState(worldIn, SEA_LANTERN, j1, k, j, structureBoundingBoxIn);
                    this.setBlockState(worldIn, BRICKS_PRISMARINE, j1, k - 1, j, structureBoundingBoxIn);
                    j1 = 13;
                }

                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 7, 3, 7, 15, 3, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                j1 = 10;

                for (int k1 = 0; k1 < 2; ++k1) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j1, 0, 10, j1, 6, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j1, 0, 12, j1, 6, 12, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.setBlockState(worldIn, SEA_LANTERN, j1, 0, 10, structureBoundingBoxIn);
                    this.setBlockState(worldIn, SEA_LANTERN, j1, 0, 12, structureBoundingBoxIn);
                    this.setBlockState(worldIn, SEA_LANTERN, j1, 4, 10, structureBoundingBoxIn);
                    this.setBlockState(worldIn, SEA_LANTERN, j1, 4, 12, structureBoundingBoxIn);
                    j1 = 12;
                }

                j1 = 8;

                for (int l1 = 0; l1 < 2; ++l1) {
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j1, 0, 7, j1, 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(worldIn, structureBoundingBoxIn, j1, 0, 14, j1, 2, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    j1 = 14;
                }

                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 8, 3, 8, 8, 3, 13, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(worldIn, structureBoundingBoxIn, 14, 3, 8, 14, 3, 13, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.spawnElder(worldIn, structureBoundingBoxIn, 11, 5, 13);
            }

            return true;
        }
    }

    static class XDoubleRoomFitHelper implements StructureOceanMonumentPieces.MonumentRoomFitHelper {
        private XDoubleRoomFitHelper() {
        }

        public boolean fits(StructureOceanMonumentPieces.RoomDefinition definition) {
            return definition.hasOpening[EnumFacing.EAST.getIndex()] && !definition.connections[EnumFacing.EAST.getIndex()].claimed;
        }

        public StructureOceanMonumentPieces.Piece create(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            room.claimed = true;
            room.connections[EnumFacing.EAST.getIndex()].claimed = true;
            return new StructureOceanMonumentPieces.DoubleXRoom(facing, room, rand);
        }
    }

    static class XYDoubleRoomFitHelper implements StructureOceanMonumentPieces.MonumentRoomFitHelper {
        private XYDoubleRoomFitHelper() {
        }

        public boolean fits(StructureOceanMonumentPieces.RoomDefinition definition) {
            if (definition.hasOpening[EnumFacing.EAST.getIndex()] && !definition.connections[EnumFacing.EAST.getIndex()].claimed && definition.hasOpening[EnumFacing.UP.getIndex()] && !definition.connections[EnumFacing.UP.getIndex()].claimed) {
                StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition = definition.connections[EnumFacing.EAST.getIndex()];
                return structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.UP.getIndex()] && !structureoceanmonumentpieces$roomdefinition.connections[EnumFacing.UP.getIndex()].claimed;
            } else {
                return false;
            }
        }

        public StructureOceanMonumentPieces.Piece create(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            room.claimed = true;
            room.connections[EnumFacing.EAST.getIndex()].claimed = true;
            room.connections[EnumFacing.UP.getIndex()].claimed = true;
            room.connections[EnumFacing.EAST.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            return new StructureOceanMonumentPieces.DoubleXYRoom(facing, room, rand);
        }
    }

    static class YDoubleRoomFitHelper implements StructureOceanMonumentPieces.MonumentRoomFitHelper {
        private YDoubleRoomFitHelper() {
        }

        public boolean fits(StructureOceanMonumentPieces.RoomDefinition definition) {
            return definition.hasOpening[EnumFacing.UP.getIndex()] && !definition.connections[EnumFacing.UP.getIndex()].claimed;
        }

        public StructureOceanMonumentPieces.Piece create(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            room.claimed = true;
            room.connections[EnumFacing.UP.getIndex()].claimed = true;
            return new StructureOceanMonumentPieces.DoubleYRoom(facing, room, rand);
        }
    }

    static class YZDoubleRoomFitHelper implements StructureOceanMonumentPieces.MonumentRoomFitHelper {
        private YZDoubleRoomFitHelper() {
        }

        public boolean fits(StructureOceanMonumentPieces.RoomDefinition definition) {
            if (definition.hasOpening[EnumFacing.NORTH.getIndex()] && !definition.connections[EnumFacing.NORTH.getIndex()].claimed && definition.hasOpening[EnumFacing.UP.getIndex()] && !definition.connections[EnumFacing.UP.getIndex()].claimed) {
                StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition = definition.connections[EnumFacing.NORTH.getIndex()];
                return structureoceanmonumentpieces$roomdefinition.hasOpening[EnumFacing.UP.getIndex()] && !structureoceanmonumentpieces$roomdefinition.connections[EnumFacing.UP.getIndex()].claimed;
            } else {
                return false;
            }
        }

        public StructureOceanMonumentPieces.Piece create(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            room.claimed = true;
            room.connections[EnumFacing.NORTH.getIndex()].claimed = true;
            room.connections[EnumFacing.UP.getIndex()].claimed = true;
            room.connections[EnumFacing.NORTH.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            return new StructureOceanMonumentPieces.DoubleYZRoom(facing, room, rand);
        }
    }

    static class ZDoubleRoomFitHelper implements StructureOceanMonumentPieces.MonumentRoomFitHelper {
        private ZDoubleRoomFitHelper() {
        }

        public boolean fits(StructureOceanMonumentPieces.RoomDefinition definition) {
            return definition.hasOpening[EnumFacing.NORTH.getIndex()] && !definition.connections[EnumFacing.NORTH.getIndex()].claimed;
        }

        public StructureOceanMonumentPieces.Piece create(EnumFacing facing, StructureOceanMonumentPieces.RoomDefinition room, Random rand) {
            StructureOceanMonumentPieces.RoomDefinition structureoceanmonumentpieces$roomdefinition = room;

            if (!room.hasOpening[EnumFacing.NORTH.getIndex()] || room.connections[EnumFacing.NORTH.getIndex()].claimed) {
                structureoceanmonumentpieces$roomdefinition = room.connections[EnumFacing.SOUTH.getIndex()];
            }

            structureoceanmonumentpieces$roomdefinition.claimed = true;
            structureoceanmonumentpieces$roomdefinition.connections[EnumFacing.NORTH.getIndex()].claimed = true;
            return new StructureOceanMonumentPieces.DoubleZRoom(facing, structureoceanmonumentpieces$roomdefinition, rand);
        }
    }
}
