package net.minecraft.world.gen.structure;

import net.minecraft.util.MathHelper;

import java.util.Map;
import java.util.Map.Entry;

public class MapGenMineshaft extends MapGenStructure {
    private double chance = 0.004D;

    public MapGenMineshaft() {
    }

    public MapGenMineshaft(Map<String, String> entryMap) {
        for (Entry<String, String> entry : entryMap.entrySet()) {
            if (entry.getKey().equals("chance")) {
                this.chance = MathHelper.parseDoubleWithDefault(entry.getValue(), this.chance);
            }
        }
    }

    public String getStructureName() {
        return "Mineshaft";
    }

    protected boolean canSpawnStructureAtCoords(int chunkX, int chunkZ) {
        return this.rand.nextDouble() < this.chance && this.rand.nextInt(80) < Math.max(Math.abs(chunkX), Math.abs(chunkZ));
    }

    protected StructureStart getStructureStart(int chunkX, int chunkZ) {
        return new StructureMineshaftStart(this.worldObj, this.rand, chunkX, chunkZ);
    }
}
