package net.minecraft.world.gen.layer;

import net.minecraft.world.biome.BiomeGenBase;

public class GenLayerBiomeEdge extends GenLayer {
    public GenLayerBiomeEdge(long seed, GenLayer parent) {
        super(seed);
        this.parent = parent;
    }

    public int[] getInts(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.parent.getInts(areaX - 1, areaY - 1, areaWidth + 2, areaHeight + 2);
        int[] aint1 = IntCache.getIntCache(areaWidth * areaHeight);

        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                this.initChunkSeed(j + areaX, i + areaY);
                int k = aint[j + 1 + (i + 1) * (areaWidth + 2)];

                if (!this.replaceBiomeEdgeIfNecessary(aint, aint1, j, i, areaWidth, k, BiomeGenBase.extremeHills.biomeID, BiomeGenBase.extremeHillsEdge.biomeID) && !this.replaceBiomeEdge(aint, aint1, j, i, areaWidth, k, BiomeGenBase.mesaPlateau_F.biomeID, BiomeGenBase.mesa.biomeID) && !this.replaceBiomeEdge(aint, aint1, j, i, areaWidth, k, BiomeGenBase.mesaPlateau.biomeID, BiomeGenBase.mesa.biomeID) && !this.replaceBiomeEdge(aint, aint1, j, i, areaWidth, k, BiomeGenBase.megaTaiga.biomeID, BiomeGenBase.taiga.biomeID)) {
                    if (k == BiomeGenBase.desert.biomeID) {
                        int l1 = aint[j + 1 + (i + 1 - 1) * (areaWidth + 2)];
                        int i2 = aint[j + 1 + 1 + (i + 1) * (areaWidth + 2)];
                        int j2 = aint[j + 1 - 1 + (i + 1) * (areaWidth + 2)];
                        int k2 = aint[j + 1 + (i + 1 + 1) * (areaWidth + 2)];

                        if (l1 != BiomeGenBase.icePlains.biomeID && i2 != BiomeGenBase.icePlains.biomeID && j2 != BiomeGenBase.icePlains.biomeID && k2 != BiomeGenBase.icePlains.biomeID) {
                            aint1[j + i * areaWidth] = k;
                        } else {
                            aint1[j + i * areaWidth] = BiomeGenBase.extremeHillsPlus.biomeID;
                        }
                    } else if (k == BiomeGenBase.swampland.biomeID) {
                        int l = aint[j + 1 + (i + 1 - 1) * (areaWidth + 2)];
                        int i1 = aint[j + 1 + 1 + (i + 1) * (areaWidth + 2)];
                        int j1 = aint[j + 1 - 1 + (i + 1) * (areaWidth + 2)];
                        int k1 = aint[j + 1 + (i + 1 + 1) * (areaWidth + 2)];

                        if (l != BiomeGenBase.desert.biomeID && i1 != BiomeGenBase.desert.biomeID && j1 != BiomeGenBase.desert.biomeID && k1 != BiomeGenBase.desert.biomeID && l != BiomeGenBase.coldTaiga.biomeID && i1 != BiomeGenBase.coldTaiga.biomeID && j1 != BiomeGenBase.coldTaiga.biomeID && k1 != BiomeGenBase.coldTaiga.biomeID && l != BiomeGenBase.icePlains.biomeID && i1 != BiomeGenBase.icePlains.biomeID && j1 != BiomeGenBase.icePlains.biomeID && k1 != BiomeGenBase.icePlains.biomeID) {
                            if (l != BiomeGenBase.jungle.biomeID && k1 != BiomeGenBase.jungle.biomeID && i1 != BiomeGenBase.jungle.biomeID && j1 != BiomeGenBase.jungle.biomeID) {
                                aint1[j + i * areaWidth] = k;
                            } else {
                                aint1[j + i * areaWidth] = BiomeGenBase.jungleEdge.biomeID;
                            }
                        } else {
                            aint1[j + i * areaWidth] = BiomeGenBase.plains.biomeID;
                        }
                    } else {
                        aint1[j + i * areaWidth] = k;
                    }
                }
            }
        }

        return aint1;
    }

    private boolean replaceBiomeEdgeIfNecessary(int[] biomeArr, int[] targetArr, int currentId, int targetId, int width, int height, int newId, int fallbackId) {
        if (!biomesEqualOrMesaPlateau(height, newId)) {
            return false;
        } else {
            int i = biomeArr[currentId + 1 + (targetId + 1 - 1) * (width + 2)];
            int j = biomeArr[currentId + 1 + 1 + (targetId + 1) * (width + 2)];
            int k = biomeArr[currentId + 1 - 1 + (targetId + 1) * (width + 2)];
            int l = biomeArr[currentId + 1 + (targetId + 1 + 1) * (width + 2)];

            if (this.canBiomesBeNeighbors(i, newId) && this.canBiomesBeNeighbors(j, newId) && this.canBiomesBeNeighbors(k, newId) && this.canBiomesBeNeighbors(l, newId)) {
                targetArr[currentId + targetId * width] = height;
            } else {
                targetArr[currentId + targetId * width] = fallbackId;
            }

            return true;
        }
    }

    private boolean replaceBiomeEdge(int[] biomeArr, int[] targetArr, int currentId, int targetId, int width, int height, int newId, int fallbackId) {
        if (height != newId) {
            return false;
        } else {
            int i = biomeArr[currentId + 1 + (targetId + 1 - 1) * (width + 2)];
            int j = biomeArr[currentId + 1 + 1 + (targetId + 1) * (width + 2)];
            int k = biomeArr[currentId + 1 - 1 + (targetId + 1) * (width + 2)];
            int l = biomeArr[currentId + 1 + (targetId + 1 + 1) * (width + 2)];

            if (biomesEqualOrMesaPlateau(i, newId) && biomesEqualOrMesaPlateau(j, newId) && biomesEqualOrMesaPlateau(k, newId) && biomesEqualOrMesaPlateau(l, newId)) {
                targetArr[currentId + targetId * width] = height;
            } else {
                targetArr[currentId + targetId * width] = fallbackId;
            }

            return true;
        }
    }

    private boolean canBiomesBeNeighbors(int biomeId1, int biomeId2) {
        if (biomesEqualOrMesaPlateau(biomeId1, biomeId2)) {
            return true;
        } else {
            BiomeGenBase biomegenbase = BiomeGenBase.getBiome(biomeId1);
            BiomeGenBase biomegenbase1 = BiomeGenBase.getBiome(biomeId2);

            if (biomegenbase != null && biomegenbase1 != null) {
                BiomeGenBase.TempCategory biomegenbase$tempcategory = biomegenbase.getTempCategory();
                BiomeGenBase.TempCategory biomegenbase$tempcategory1 = biomegenbase1.getTempCategory();
                return biomegenbase$tempcategory == biomegenbase$tempcategory1 || biomegenbase$tempcategory == BiomeGenBase.TempCategory.MEDIUM || biomegenbase$tempcategory1 == BiomeGenBase.TempCategory.MEDIUM;
            } else {
                return false;
            }
        }
    }
}
