package net.minecraft.world.gen.feature;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

import java.util.Random;

public abstract class WorldGenAbstractTree extends WorldGenerator {
    public WorldGenAbstractTree(boolean notify) {
        super(notify);
    }

    protected boolean canGrowInto(Block blockType) {
        Material material = blockType.getMaterial();
        return material == Material.air || material == Material.leaves || blockType == Blocks.grass || blockType == Blocks.dirt || blockType == Blocks.log || blockType == Blocks.log2 || blockType == Blocks.sapling || blockType == Blocks.vine;
    }

    public void generateSaplings(World worldIn, Random random, BlockPos pos) {
    }

    protected void setDirtAt(World worldIn, BlockPos pos) {
        if (worldIn.getBlockState(pos).getBlock() != Blocks.dirt) {
            this.setBlockAndNotifyAdequately(worldIn, pos, Blocks.dirt.getDefaultState());
        }
    }
}
